/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.validation.testutils.ValidationTestUtils;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public abstract class BaseValidationHandlerTest {
    public SchemaRouter schemaRouter;
    public SchemaParser parser;
    public Router router;
    public HttpServer server;
    public WebClient client;

    @BeforeEach
    public void setUp(Vertx vertx, VertxTestContext testContext) {
        this.router = Router.router((Vertx)vertx);
        ValidationTestUtils.mountRouterFailureHandler(this.router);
        this.schemaRouter = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.schemaRouter);
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setDefaultPort(9000).setDefaultHost("localhost"));
        this.server = vertx.createHttpServer().requestHandler((Handler)this.router).listen(9000, testContext.succeedingThenComplete());
    }

    @AfterEach
    public void tearDown(VertxTestContext testContext) {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.server.close(testContext.succeedingThenComplete());
        } else {
            testContext.completeNow();
        }
    }
}

