/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.impl.RequestParameterImpl;
import io.vertx.ext.web.validation.impl.RequestParametersImpl;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class RequestParametersTest {
    @Test
    public void testRequestParameterToJsonNumber() {
        RequestParameterImpl param = new RequestParameterImpl((Object)1);
        Assert.assertEquals((Object)1, (Object)param.get());
    }

    @Test
    public void testRequestParameterToJsonString() {
        RequestParameterImpl param = new RequestParameterImpl((Object)"string");
        Assert.assertEquals((Object)"string", (Object)param.get());
    }

    @Test
    public void testToJsonObjectEmpty() {
        RequestParametersImpl params = new RequestParametersImpl();
        JsonObject obj = params.toJson();
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("path").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("cookie").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("query").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("header").size());
        Assert.assertNull((Object)obj.getValue("body"));
    }

    @Test
    public void testToJsonObjectWithNull() {
        HashMap<String, RequestParameterImpl> map = new HashMap<String, RequestParameterImpl>();
        map.put("aaa", new RequestParameterImpl((Object)1));
        map.put("bbb", null);
        RequestParametersImpl params = new RequestParametersImpl();
        params.setPathParameters(map);
        JsonObject obj = params.toJson();
        Assert.assertEquals((long)2L, (long)obj.getJsonObject("path").size());
        Assert.assertEquals((Object)1, (Object)obj.getJsonObject("path").getValue("aaa"));
        Assert.assertNull((Object)obj.getJsonObject("path").getValue("bbb"));
    }
}

