/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parameter.ExplodedArrayValueParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ExplodedTupleValueParameterParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestParsers;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class ExplodedTupleValueParameterParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        ExplodedTupleValueParameterParser parser = new ExplodedTupleValueParameterParser("bla", TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, ValueParser.BOOLEAN_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla", Lists.newArrayList((Object[])new String[]{"1", "hello", "2", "true"}));
        map.put("other", Collections.singletonList("aaa"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)TestParsers.SAMPLE_TUPLE.copy().add((Object)true));
        });
        ((MapAssert)Assertions.assertThat(map).containsKey((Object)"other")).doesNotContainKey((Object)"bla");
    }

    @Test
    public void testNoAdditionalItems() {
        ExplodedTupleValueParameterParser parser = new ExplodedTupleValueParameterParser("bla", TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, null);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla", Lists.newArrayList((Object[])new String[]{"1", "hello", "2", "true"}));
        map.put("other", Collections.singletonList("aaa"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)TestParsers.SAMPLE_TUPLE.copy().add((Object)"true"));
        });
        ((MapAssert)Assertions.assertThat(map).containsKey((Object)"other")).doesNotContainKey((Object)"bla");
    }

    @Test
    public void testNullAndEmptyString() {
        ExplodedTupleValueParameterParser parser = new ExplodedTupleValueParameterParser("bla", TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, ValueParser.BOOLEAN_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla", Lists.newArrayList((Object[])new String[]{"", "", "2", "true"}));
        map.put("other", Collections.singletonList("aaa"));
        Object result = parser.parseParameter(map);
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)new JsonArray().addNull().add((Object)"").add((Object)2.0).add((Object)true));
        });
        ((MapAssert)Assertions.assertThat(map).containsKey((Object)"other")).doesNotContainKey((Object)"bla");
    }

    @Test
    public void testInvalid() {
        ExplodedArrayValueParameterParser parser = new ExplodedArrayValueParameterParser("bla", ValueParser.BOOLEAN_PARSER);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bla", Lists.newArrayList((Object[])new String[]{"hello", "1", "hello"}));
        map.put("other", Collections.singletonList("aaa"));
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parseParameter(map));
        ((MapAssert)Assertions.assertThat(map).containsKey((Object)"other")).doesNotContainKey((Object)"bla");
    }
}

