/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parser.SplitterCharArrayParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class SplitterCharArrayValueParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        SplitterCharArrayParser parser = new SplitterCharArrayParser(ValueParser.BOOLEAN_PARSER, ",");
        JsonArray result = parser.parse("true,false");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> Assertions.assertThat((Iterable)ja).containsOnly(new Object[]{true, false}));
    }

    @Test
    public void testNull() {
        SplitterCharArrayParser parser = new SplitterCharArrayParser(ValueParser.BOOLEAN_PARSER, ",");
        JsonArray result = parser.parse("true,,false");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> Assertions.assertThat((Iterable)ja).containsOnly(new Object[]{true, null, false}));
    }

    @Test
    public void testEmptyString() {
        SplitterCharArrayParser parser = new SplitterCharArrayParser(ValueParser.NOOP_PARSER, ",");
        JsonArray result = parser.parse(",,bla");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> Assertions.assertThat((Iterable)ja).containsOnly(new Object[]{"", "", "bla"}));
    }

    @Test
    public void testInvalid() {
        SplitterCharArrayParser parser = new SplitterCharArrayParser(ValueParser.BOOLEAN_PARSER, ",");
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parse("true,hello"));
    }
}

