/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parser.SplitterCharObjectParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestParsers;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class SplitterCharObjectValueParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER, ",");
        JsonObject result = parser.parse("prop1,1,prop2,2.1,prop3,aaa,prop4,true,other,hello");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello"));
        });
    }

    @Test
    public void testNoAdditionalProperties() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, null, ",");
        JsonObject result = parser.parse("prop1,1,prop2,2.1,prop3,aaa,prop4,true,other,hello");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().put("other", (Object)"hello"));
        });
    }

    @Test
    public void testInvalidNumber() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER, ",");
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parse("true,hello,1"));
    }

    @Test
    public void testInvalidValueType() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, ValueParser.NOOP_PARSER, ",");
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parse("prop1,bla"));
    }

    @Test
    public void testMissingProps() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, null, ",");
        JsonObject result = parser.parse("prop1,1");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)new JsonObject().put("prop1", (Object)1L));
        });
    }

    @Test
    public void testNullAndEmptyString() {
        SplitterCharObjectParser parser = new SplitterCharObjectParser(TestParsers.SAMPLE_PROPERTIES_PARSERS, TestParsers.SAMPLE_PATTERN_PROPERTIES_PARSERS, null, ",");
        JsonObject result = parser.parse("prop1,,prop2,2.1,prop3,,prop4,true");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonObject.class, jo -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)jo).isEqualTo((Object)TestParsers.SAMPLE_OBJECT.copy().putNull("prop1").put("prop3", (Object)""));
        });
    }
}

