/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.impl.parser.SplitterCharTupleParser;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.ext.web.validation.testutils.TestParsers;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.junit5.VertxExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class SplitterCharTupleValueParserTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testValid() {
        SplitterCharTupleParser parser = new SplitterCharTupleParser(TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, ValueParser.BOOLEAN_PARSER, ",");
        JsonArray result = parser.parse("1,hello,2,true");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)TestParsers.SAMPLE_TUPLE.copy().add((Object)true));
        });
    }

    @Test
    public void testNoAdditionalProperties() {
        SplitterCharTupleParser parser = new SplitterCharTupleParser(TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, null, ",");
        JsonArray result = parser.parse("1,hello,2,true");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)TestParsers.SAMPLE_TUPLE.copy().add((Object)"true"));
        });
    }

    @Test
    public void testNull() {
        SplitterCharTupleParser parser = new SplitterCharTupleParser(TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, null, ",");
        JsonArray result = parser.parse(",hello,");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)new JsonArray().addNull().add((Object)"hello").addNull());
        });
    }

    @Test
    public void testEmptyString() {
        SplitterCharTupleParser parser = new SplitterCharTupleParser(TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, null, ",");
        JsonArray result = parser.parse("1,,2");
        Assertions.assertThat((Object)result).isInstanceOfSatisfying(JsonArray.class, ja -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)ja).isEqualTo((Object)new JsonArray().add((Object)1.0).add((Object)"").add((Object)2.0));
        });
    }

    @Test
    public void testInvalid() {
        SplitterCharTupleParser parser = new SplitterCharTupleParser(TestParsers.SAMPLE_TUPLE_ITEMS_PARSERS, ValueParser.BOOLEAN_PARSER, ",");
        Assertions.assertThatExceptionOfType(MalformedValueException.class).isThrownBy(() -> parser.parse("true,hello"));
    }
}

