/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.impl.ValueParserInferenceUtils;
import io.vertx.ext.web.validation.impl.parser.ValueParser;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaParser;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.SchemaRouterOptions;
import io.vertx.json.schema.common.dsl.SchemaBuilder;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.json.schema.draft7.dsl.Schemas;
import io.vertx.junit5.VertxExtension;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class ValueParserInferenceUtilsTest {
    SchemaRouter router;
    SchemaParser parser;

    @BeforeEach
    public void setUp(Vertx vertx) {
        this.router = SchemaRouter.create((Vertx)vertx, (SchemaRouterOptions)new SchemaRouterOptions());
        this.parser = Draft7SchemaParser.create((SchemaRouter)this.router);
    }

    @Test
    public void testPrimitiveInference() {
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerPrimitiveParser((Object)new JsonObject().put("type", (Object)"integer"))).isSameAs((Object)ValueParser.LONG_PARSER);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerPrimitiveParser((Object)new JsonObject().put("type", (Object)"number"))).isSameAs((Object)ValueParser.DOUBLE_PARSER);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerPrimitiveParser((Object)new JsonObject().put("type", (Object)"string"))).isSameAs((Object)ValueParser.NOOP_PARSER);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerPrimitiveParser((Object)new JsonObject().put("type", (Object)"boolean"))).isSameAs((Object)ValueParser.BOOLEAN_PARSER);
    }

    @Test
    public void testObjectInference() {
        Schema s = Schemas.objectSchema().property("simpleProp", (SchemaBuilder)Schemas.stringSchema()).patternProperty(Pattern.compile("a*"), (SchemaBuilder)Schemas.intSchema()).additionalProperties((SchemaBuilder)Schemas.booleanSchema()).build(this.parser);
        Assertions.assertThat((Map)ValueParserInferenceUtils.infeerPropertiesParsersForObjectSchema((Object)s.getJson())).containsOnly(new Map.Entry[]{Assertions.entry((Object)"simpleProp", (Object)ValueParser.NOOP_PARSER)});
        ((MapAssert)Assertions.assertThat((Map)ValueParserInferenceUtils.infeerPatternPropertiesParsersForObjectSchema((Object)s.getJson())).hasEntrySatisfying(new Condition(p -> p.toString().equals("a*"), "Must have a* as key", new Object[0]), new Condition(vp -> vp == ValueParser.LONG_PARSER, "Must have LONG_PARSER as value", new Object[0]))).hasSize(1);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalPropertiesParserForObjectSchema((Object)s.getJson())).isSameAs((Object)ValueParser.BOOLEAN_PARSER);
    }

    @Test
    public void testAdditionalPropertiesObjectInference() {
        JsonObject schema = new JsonObject().put("additionalProperties", (Object)true);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalPropertiesParserForObjectSchema((Object)schema)).isSameAs((Object)ValueParser.NOOP_PARSER);
    }

    @Test
    public void testNoAdditionalPropertiesObjectInference() {
        JsonObject schema = new JsonObject().put("additionalProperties", (Object)false);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalPropertiesParserForObjectSchema((Object)schema)).isNull();
    }

    @Test
    public void testArrayInference() {
        Schema s = Schemas.arraySchema().items((SchemaBuilder)Schemas.intSchema()).build(this.parser);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerItemsParserForArraySchema((Object)s.getJson())).isSameAs((Object)ValueParser.LONG_PARSER);
    }

    @Test
    public void testTupleInference() {
        Schema s = Schemas.tupleSchema().item((SchemaBuilder)Schemas.intSchema()).item((SchemaBuilder)Schemas.numberSchema()).additionalItems((SchemaBuilder)Schemas.booleanSchema()).build(this.parser);
        Assertions.assertThat((List)ValueParserInferenceUtils.infeerTupleParsersForArraySchema((Object)s.getJson())).containsExactly((Object[])new ValueParser[]{ValueParser.LONG_PARSER, ValueParser.DOUBLE_PARSER});
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalItemsParserForArraySchema((Object)s.getJson())).isSameAs((Object)ValueParser.BOOLEAN_PARSER);
    }

    @Test
    public void testAdditionalItemsInference() {
        JsonObject schema = new JsonObject().put("additionalItems", (Object)true);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalItemsParserForArraySchema((Object)schema)).isSameAs((Object)ValueParser.NOOP_PARSER);
    }

    @Test
    public void testNoAdditionalItemsInference() {
        JsonObject schema = new JsonObject().put("additionalItems", (Object)false);
        Assertions.assertThat((Object)ValueParserInferenceUtils.infeerAdditionalItemsParserForArraySchema((Object)schema)).isNull();
    }
}

