/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.validation.impl.parameter;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.validation.MalformedValueException;
import io.vertx.ext.web.validation.ParameterProcessorException;
import io.vertx.ext.web.validation.RequestParameter;
import io.vertx.ext.web.validation.impl.ParameterLocation;
import io.vertx.ext.web.validation.impl.parameter.ParameterParser;
import io.vertx.ext.web.validation.impl.parameter.ParameterProcessor;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParameterProcessorImpl
implements ParameterProcessor,
Comparable<ParameterProcessorImpl> {
    private String parameterName;
    private ParameterLocation location;
    private boolean isOptional;
    private ParameterParser parser;
    private SchemaRepository repo;
    private JsonObject schema;

    public ParameterProcessorImpl(String parameterName, ParameterLocation location, boolean isOptional, ParameterParser parser, SchemaRepository repo, JsonObject schema) {
        this.parameterName = parameterName;
        this.location = location;
        this.isOptional = isOptional;
        this.parser = parser;
        this.repo = repo;
        this.schema = schema;
    }

    @Override
    public Future<RequestParameter> process(Map<String, List<String>> params) {
        Object json;
        try {
            json = this.parser.parseParameter(params);
        }
        catch (MalformedValueException e) {
            throw ParameterProcessorException.createParsingError(this.parameterName, this.location, e);
        }
        if (json != null) {
            return Future.future(p -> {
                OutputUnit result = this.repo.validator(JsonSchema.of((JsonObject)this.schema)).validate(json);
                if (result.getValid().booleanValue()) {
                    p.complete((Object)RequestParameter.create(json));
                } else {
                    p.fail((Throwable)result.toException((Object)""));
                }
            }).recover(t -> Future.failedFuture((Throwable)((Object)ParameterProcessorException.createValidationError(this.parameterName, this.location, t))));
        }
        if (!this.isOptional) {
            throw ParameterProcessorException.createMissingParameterWhenRequired(this.parameterName, this.location);
        }
        RequestParameter defaultValue = Optional.ofNullable(this.schema.getValue("default")).map(RequestParameter::create).orElse(null);
        return Future.succeededFuture((Object)defaultValue);
    }

    @Override
    public String getName() {
        return this.parameterName;
    }

    @Override
    public ParameterLocation getLocation() {
        return this.location;
    }

    @Override
    public int compareTo(ParameterProcessorImpl o) {
        return this.parser.compareTo(o.parser);
    }
}

