/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.StaticHandlerImpl;

@VertxGen
public interface StaticHandler
extends Handler<RoutingContext> {
    public static final String DEFAULT_WEB_ROOT = "webroot";
    public static final boolean DEFAULT_FILES_READ_ONLY = true;
    public static final long DEFAULT_MAX_AGE_SECONDS = 86400L;
    public static final boolean DEFAULT_CACHING_ENABLED = true;
    public static final boolean DEFAULT_DIRECTORY_LISTING = false;
    public static final String DEFAULT_DIRECTORY_TEMPLATE = "vertx-web-directory.html";
    public static final boolean DEFAULT_INCLUDE_HIDDEN = true;
    public static final long DEFAULT_CACHE_ENTRY_TIMEOUT = 30000L;
    public static final String DEFAULT_INDEX_PAGE = "/index.html";
    public static final int DEFAULT_MAX_CACHE_SIZE = 10000;
    public static final boolean DEFAULT_ALWAYS_ASYNC_FS = false;
    public static final boolean DEFAULT_ENABLE_FS_TUNING = true;
    public static final long DEFAULT_MAX_AVG_SERVE_TIME_NS = 1000000L;

    public static StaticHandler create() {
        return new StaticHandlerImpl();
    }

    public static StaticHandler create(String root) {
        return new StaticHandlerImpl(root);
    }

    @Fluent
    public StaticHandler setWebRoot(String var1);

    @Fluent
    public StaticHandler setFilesReadOnly(boolean var1);

    @Fluent
    public StaticHandler setMaxAgeSeconds(long var1);

    @Fluent
    public StaticHandler setCachingEnabled(boolean var1);

    @Fluent
    public StaticHandler setDirectoryListing(boolean var1);

    @Fluent
    public StaticHandler setIncludeHidden(boolean var1);

    @Fluent
    public StaticHandler setCacheEntryTimeout(long var1);

    @Fluent
    public StaticHandler setIndexPage(String var1);

    @Fluent
    public StaticHandler setMaxCacheSize(int var1);

    @Fluent
    public StaticHandler setAlwaysAsyncFS(boolean var1);

    @Fluent
    public StaticHandler setEnableFSTuning(boolean var1);

    @Fluent
    public StaticHandler setMaxAvgServeTimeNs(long var1);

    @Fluent
    public StaticHandler setDirectoryTemplate(String var1);
}

