/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.Iterator;

public abstract class RoutingContextImplBase
implements RoutingContext {
    private static final Logger log = LoggerFactory.getLogger(RoutingContextImplBase.class);
    protected final String mountPoint;
    protected final HttpServerRequest request;
    protected Iterator<RouteImpl> iter;
    protected RouteImpl currentRoute;

    protected RoutingContextImplBase(String mountPoint, HttpServerRequest request, Iterator<RouteImpl> iter) {
        this.mountPoint = mountPoint;
        this.request = request;
        this.iter = iter;
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        return this.currentRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean iterateNext() {
        boolean failed = this.failed();
        while (this.iter.hasNext()) {
            RouteImpl route = this.iter.next();
            if (!route.matches(this, this.mountPoint(), failed)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Route matches: " + route));
            }
            try {
                this.currentRoute = route;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Calling the " + (failed ? "failure" : "") + " handler"));
                }
                if (failed) {
                    route.handleFailure(this);
                } else {
                    route.handleContext(this);
                }
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Throwable thrown from handler", t);
                }
                if (!failed) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failing the routing");
                    }
                    this.fail(t);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failure in handling failure");
                    }
                    this.unhandledFailure(-1, t, route.router());
                }
            }
            finally {
                this.currentRoute = null;
            }
            return true;
        }
        return false;
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code = statusCode != -1 ? statusCode : 500;
        this.response().setStatusCode(code);
        this.response().end(this.response().getStatusMessage());
        if (failure != null) {
            if (router.exceptionHandler() != null) {
                router.exceptionHandler().handle((Object)failure);
            } else {
                log.error((Object)"Unexpected exception in route", failure);
            }
        }
    }
}

