/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import java.util.Base64;

public class BasicAuthHandlerImpl
extends AuthHandlerImpl {
    private final String realm;

    public BasicAuthHandlerImpl(AuthProvider authProvider, String realm) {
        super(authProvider);
        this.realm = realm;
    }

    public void handle(RoutingContext context) {
        String uri = context.request().absoluteURI();
        User user = context.user();
        if (user != null) {
            this.authorise(user, context);
        } else {
            HttpServerRequest request = context.request();
            String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
            if (authorization == null) {
                this.handle401(context);
            } else {
                String spass;
                String suser;
                String sscheme;
                try {
                    String[] parts = authorization.split(" ");
                    sscheme = parts[0];
                    String[] credentials = new String(Base64.getDecoder().decode(parts[1])).split(":");
                    suser = credentials[0];
                    spass = credentials.length > 1 ? credentials[1] : null;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.handle401(context);
                    return;
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    context.fail(e);
                    return;
                }
                if (!"Basic".equals(sscheme)) {
                    context.fail(400);
                } else {
                    JsonObject authInfo = new JsonObject().put("username", suser).put("password", spass);
                    this.authProvider.authenticate(authInfo, res -> {
                        if (res.succeeded()) {
                            User authenticated = (User)res.result();
                            context.setUser(authenticated);
                            this.authorise(authenticated, context);
                        } else {
                            this.handle401(context);
                        }
                    });
                }
            }
        }
    }

    private void handle401(RoutingContext context) {
        context.response().putHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        context.fail(401);
    }
}

