/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import org.junit.AfterClass;
import org.junit.Test;

public class RerouteTest
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testReroute() throws Exception {
        this.router.get("/users/:name").handler(ctx -> ctx.response().end("/users/:name"));
        this.router.get("/me").handler(ctx -> ctx.reroute("/users/paulo"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "/users/:name");
    }

    @Test
    public void testRerouteReparse() throws Exception {
        this.router.get("/users/:name").handler(ctx -> ctx.response().end(ctx.request().getParam("name")));
        this.router.get("/me").handler(ctx -> ctx.reroute("/users/paulo"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "paulo");
    }

    @Test
    public void testRerouteMethod() throws Exception {
        this.router.post("/me").handler(ctx -> ctx.response().end("POST"));
        this.router.get("/me").handler(ctx -> ctx.reroute(HttpMethod.POST, "/me"));
        this.testRequest(HttpMethod.GET, "/me", 200, "OK", "POST");
    }

    @Test
    public void testRerouteWithBody() throws Exception {
        this.router.route("/test/*").handler((Handler)BodyHandler.create());
        this.router.route("/test/v1").handler(ctx -> ctx.reroute("/test/v2"));
        this.router.route("/test/v2").handler(ctx -> ctx.response().end());
        this.testRequest(HttpMethod.POST, "/test/v1", req -> {
            req.setChunked(true);
            req.write("Test HTTP Body");
        }, 200, "OK", null);
    }

    @Test
    public void testRerouteFailure() throws Exception {
        this.router.get("/error/400").handler(ctx -> ctx.response().setStatusCode(400).end("/error/400"));
        this.router.get("/me").handler(ctx -> ctx.fail(400));
        this.router.get().failureHandler(ctx -> {
            if (ctx.statusCode() == 400) {
                ctx.reroute("/error/400");
            } else {
                ctx.next();
            }
        });
        this.testRequest(HttpMethod.GET, "/me", 400, "Bad Request", "/error/400");
    }
}

