/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.SessionHandlerTestBase;
import io.vertx.ext.web.handler.SomeSerializable;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SessionImpl;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class ClusteredSessionHandlerTest
extends SessionHandlerTestBase {
    int numNodes = 3;
    byte[] bytes = TestUtils.randomByteArray((int)100);
    Buffer buffer = TestUtils.randomBuffer((int)100);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        VertxOptions options = new VertxOptions();
        options.setClustered(true);
        options.setClusterManager(this.getClusterManager());
        this.startNodes(this.numNodes, options);
        this.store = ClusteredSessionStore.create((Vertx)this.vertices[0], (long)3000L);
    }

    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Test
    public void testClusteredSession() throws Exception {
        Router router1 = Router.router((Vertx)this.vertices[0]);
        router1.route().handler((Handler)CookieHandler.create());
        ClusteredSessionStore store1 = ClusteredSessionStore.create((Vertx)this.vertices[0]);
        router1.route().handler((Handler)SessionHandler.create((SessionStore)store1));
        HttpServer server1 = this.vertices[0].createHttpServer(new HttpServerOptions().setPort(8081).setHost("localhost"));
        server1.requestHandler(arg_0 -> ((Router)router1).accept(arg_0));
        CountDownLatch latch1 = new CountDownLatch(1);
        server1.listen(this.onSuccess(s -> latch1.countDown()));
        HttpClient client1 = this.vertices[0].createHttpClient(new HttpClientOptions());
        Router router2 = Router.router((Vertx)this.vertices[1]);
        router2.route().handler((Handler)CookieHandler.create());
        ClusteredSessionStore store2 = ClusteredSessionStore.create((Vertx)this.vertices[1]);
        router2.route().handler((Handler)SessionHandler.create((SessionStore)store2));
        HttpServer server2 = this.vertices[1].createHttpServer(new HttpServerOptions().setPort(8082).setHost("localhost"));
        server2.requestHandler(arg_0 -> ((Router)router2).accept(arg_0));
        CountDownLatch latch2 = new CountDownLatch(1);
        server2.listen(this.onSuccess(s -> latch2.countDown()));
        HttpClient client2 = this.vertices[0].createHttpClient(new HttpClientOptions());
        Router router3 = Router.router((Vertx)this.vertices[2]);
        router3.route().handler((Handler)CookieHandler.create());
        ClusteredSessionStore store3 = ClusteredSessionStore.create((Vertx)this.vertices[2]);
        router3.route().handler((Handler)SessionHandler.create((SessionStore)store3));
        HttpServer server3 = this.vertices[2].createHttpServer(new HttpServerOptions().setPort(8083).setHost("localhost"));
        server3.requestHandler(arg_0 -> ((Router)router3).accept(arg_0));
        CountDownLatch latch3 = new CountDownLatch(1);
        server3.listen(this.onSuccess(s -> latch3.countDown()));
        HttpClient client3 = this.vertices[0].createHttpClient(new HttpClientOptions());
        router1.route().handler(rc -> {
            Session sess = rc.session();
            sess.put("foo", (Object)"bar");
            this.stuffSession(sess);
            rc.response().end();
        });
        router2.route().handler(rc -> {
            Session sess = rc.session();
            this.checkSession(sess);
            this.assertEquals("bar", sess.get("foo"));
            sess.put("eek", (Object)"wibble");
            rc.response().end();
        });
        router3.route().handler(rc -> {
            Session sess = rc.session();
            this.checkSession(sess);
            this.assertEquals("bar", sess.get("foo"));
            this.assertEquals("wibble", sess.get("eek"));
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequestBuffer(client1, HttpMethod.GET, 8081, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequestBuffer(client2, HttpMethod.GET, 8082, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequestBuffer(client3, HttpMethod.GET, 8083, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
    }

    @Test
    public void testSessionSerializationNullPrincipal() {
        long timeout = 123L;
        SessionImpl session = (SessionImpl)this.store.createSession(timeout);
        this.stuffSession((Session)session);
        this.checkSession((Session)session);
        Buffer buffer = Buffer.buffer();
        session.writeToBuffer(buffer);
        SessionImpl session2 = (SessionImpl)this.store.createSession(0L);
        session2.readFromBuffer(0, buffer);
        this.checkSession((Session)session2);
        this.assertEquals(timeout, session2.timeout());
        this.assertEquals(session.id(), session2.id());
    }

    private void stuffSession(Session session) {
        session.put("somelong", (Object)123456L);
        session.put("someint", (Object)1234);
        session.put("someshort", (Object)123);
        session.put("somebyte", (Object)12);
        session.put("somedouble", (Object)123.456);
        session.put("somefloat", (Object)Float.valueOf(123.456f));
        session.put("somechar", (Object)Character.valueOf('X'));
        session.put("somebooleantrue", (Object)true);
        session.put("somebooleanfalse", (Object)false);
        session.put("somestring", (Object)"wibble");
        session.put("somebytes", (Object)this.bytes);
        session.put("somebuffer", (Object)this.buffer);
        session.put("someserializable", (Object)new SomeSerializable("eek"));
        session.put("someclusterserializable", (Object)new JsonObject().put("foo", "bar"));
    }

    private void checkSession(Session session) {
        this.assertEquals(123456L, (Long)session.get("somelong"));
        this.assertEquals(1234L, ((Integer)session.get("someint")).intValue());
        this.assertEquals(123L, ((Short)session.get("someshort")).shortValue());
        this.assertEquals(12L, ((Byte)session.get("somebyte")).byteValue());
        this.assertEquals(123.456, (Double)session.get("somedouble"), 0.0);
        this.assertEquals(123.456f, ((Float)session.get("somefloat")).floatValue(), 0.0);
        this.assertEquals(88L, ((Character)session.get("somechar")).charValue());
        this.assertTrue((Boolean)session.get("somebooleantrue"));
        this.assertFalse((Boolean)session.get("somebooleanfalse"));
        this.assertEquals("wibble", session.get("somestring"));
        this.assertTrue(TestUtils.byteArraysEqual((byte[])this.bytes, (byte[])((byte[])session.get("somebytes"))));
        this.assertEquals(this.buffer, session.get("somebuffer"));
        JsonObject json = (JsonObject)session.get("someclusterserializable");
        this.assertNotNull(json);
        this.assertEquals("bar", json.getString("foo"));
    }

    @Test
    public void testRetryTimeout() throws Exception {
        long val = this.doTestSessionRetryTimeout();
        this.assertTrue(val >= 3000L && val < 5000L);
    }
}

