/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.UserSessionHandler;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SessionImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class BasicAuthHandlerTest
extends AuthHandlerTestBase {
    @Test
    public void testLoginDefaultRealm() throws Exception {
        this.doLogin("vertx-web");
    }

    @Test
    public void testLoginNonDefaultRealm() throws Exception {
        this.doLogin("aardvarks");
    }

    private void doLogin(String realm) throws Exception {
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("tim", rc.user().principal().getString("username"));
            rc.response().end("Welcome to the protected resource!");
        };
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthProvider)authProvider, (String)realm));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testWithSessions() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        SerializingSessionStore store = new SerializingSessionStore();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.router.route().handler((Handler)UserSessionHandler.create((AuthProvider)authProvider));
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthProvider)authProvider));
        AtomicReference sessionID = new AtomicReference();
        AtomicInteger count = new AtomicInteger();
        Handler handler = rc -> {
            int c = count.incrementAndGet();
            this.assertNotNull(rc.session());
            String sessID = (String)sessionID.get();
            if (sessID != null) {
                this.assertEquals(sessID, rc.session().id());
            }
            this.assertNotNull(rc.user());
            this.assertEquals("tim", rc.user().principal().getString("username"));
            if (c == 7) {
                rc.clearUser();
            }
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/somepage").handler(handler);
        AtomicReference sessionCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"vertx-web\"", wwwAuth);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNull(setCookie);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            sessionCookie.set(setCookie);
        }, 200, "OK", "Welcome to the protected resource!");
        for (int i = 0; i < 5; ++i) {
            this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("cookie", (String)sessionCookie.get()), resp -> {
                String wwwAuth = resp.headers().get("WWW-Authenticate");
                this.assertNull(wwwAuth);
            }, 200, "OK", "Welcome to the protected resource!");
        }
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"vertx-web\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNull(wwwAuth);
        }, 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testLoginFail() throws Exception {
        String realm = "vertx-web";
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.router.route("/protected/*").handler((Handler)BasicAuthHandler.create((AuthProvider)authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic dGltOn5hdXdhZ2Vz"), resp -> {
            String wwwAuth = resp.headers().get("WWW-Authenticate");
            this.assertNotNull(wwwAuth);
            this.assertEquals("Basic realm=\"" + realm + "\"", wwwAuth);
        }, 401, "Unauthorized", null);
    }

    @Override
    protected AuthHandler createAuthHandler(AuthProvider authProvider) {
        return BasicAuthHandler.create((AuthProvider)authProvider);
    }

    @Test
    public void testSecurityBypass() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.router.route().pathRegex("/api/.*").handler((Handler)BasicAuthHandler.create((AuthProvider)authProvider));
        this.router.route("/api/v1/standard-job-profiles").handler(handler);
        this.testRequest(HttpMethod.GET, "//api/v1/standard-job-profiles", 401, "Unauthorized");
    }

    private class SerializingSessionStore
    implements SessionStore {
        private Map<String, Buffer> sessions = new ConcurrentHashMap<String, Buffer>();

        private SerializingSessionStore() {
        }

        public long retryTimeout() {
            return 0L;
        }

        public Session createSession(long timeout) {
            return new SessionImpl(timeout);
        }

        public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
            SessionImpl sess;
            Buffer buff = this.sessions.get(id);
            if (buff != null) {
                sess = new SessionImpl();
                sess.readFromBuffer(0, buff);
            } else {
                sess = null;
            }
            BasicAuthHandlerTest.this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)sess)));
        }

        public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
            boolean deleted = this.sessions.remove(id) != null;
            BasicAuthHandlerTest.this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)deleted)));
        }

        public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
            ClusterSerializable cs = (ClusterSerializable)session;
            Buffer buff = Buffer.buffer();
            cs.writeToBuffer(buff);
            this.sessions.put(session.id(), buff);
            BasicAuthHandlerTest.this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)true)));
        }

        public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
            this.sessions.clear();
            BasicAuthHandlerTest.this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)true)));
        }

        public void size(Handler<AsyncResult<Integer>> resultHandler) {
            BasicAuthHandlerTest.this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)this.sessions.size())));
        }

        public void close() {
            this.sessions.clear();
        }
    }
}

