/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.web.RoutingContext;
import io.vertx.core.Handler;
import io.vertx.ext.web.handler.LoggerFormat;

/**
 * A handler which logs request information to the Vert.x logger.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.LoggerHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.web.handler.LoggerHandler.class)
public class LoggerHandler implements Handler<RoutingContext> {

  public static final io.vertx.lang.rxjava.TypeArg<LoggerHandler> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new LoggerHandler((io.vertx.ext.web.handler.LoggerHandler) obj),
    LoggerHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.LoggerHandler delegate;
  
  public LoggerHandler(io.vertx.ext.web.handler.LoggerHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.LoggerHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Create a handler with default format
   * @return the handler
   */
  public static LoggerHandler create() { 
    LoggerHandler ret = LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create());
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param format the format
   * @return the handler
   */
  public static LoggerHandler create(LoggerFormat format) { 
    LoggerHandler ret = LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create(format));
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param immediate true if logging should occur as soon as request arrives
   * @param format the format
   * @return the handler
   */
  public static LoggerHandler create(boolean immediate, LoggerFormat format) { 
    LoggerHandler ret = LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create(immediate, format));
    return ret;
  }


  public static LoggerHandler newInstance(io.vertx.ext.web.handler.LoggerHandler arg) {
    return arg != null ? new LoggerHandler(arg) : null;
  }
}
