/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.impl.HeaderTooLongException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderParser {
    private static final Logger log = LoggerFactory.getLogger(HeaderParser.class);
    static final int MAX_HEADER_SIZE = 200;
    private static Pattern COMMA_SPLITTER = Pattern.compile(",(?=(?:(?<!\\\\)\"(?:(?!(?<!\\\\)\").)*(?<!\\\\)\"|\\\\.|[^\"])*$)");
    private static final Pattern HYPHEN_SPLITTER = Pattern.compile("-|_");
    private static final Pattern PARAMETER_FINDER = Pattern.compile("\\s*+;\\s*+(?<key>[a-zA-Z0-9]++)\\s*+(?:=\\s*+(?:(?<value1>[a-zA-Z0-9.@#\\-%_]++)|\"(?<value2>(?:[^\\\\\"]*+(?:\\\\.)?)*+)\"))?+");
    private static final Comparator<ParsedHeaderValue> HEADER_SORTER = (left, right) -> right.weightedOrder() - left.weightedOrder();

    public static <T extends ParsedHeaderValue> List<T> convertToParsedHeaderValues(String unparsedHeaderValue, Function<String, T> objectCreator) {
        if (unparsedHeaderValue == null) {
            return Collections.emptyList();
        }
        if (unparsedHeaderValue.length() > 200) {
            throw new HeaderTooLongException("Header longer than 200 characters");
        }
        String[] listedMIMEs = COMMA_SPLITTER.split(unparsedHeaderValue);
        ArrayList<T> parsedMIMEs = new ArrayList<T>(listedMIMEs.length);
        for (String listedMIME : listedMIMEs) {
            parsedMIMEs.add(objectCreator.apply(HeaderParser.quotesRemover(listedMIME)));
        }
        return parsedMIMEs;
    }

    public static <T extends ParsedHeaderValue> List<T> sort(List<T> headers) {
        Collections.sort(headers, HEADER_SORTER);
        return headers;
    }

    static String quotesRemover(String val) {
        return val.replace("\\\"", "\"");
    }

    static String matchedSelector(String ... matches) {
        for (String match : matches) {
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public static void parseHeaderValue(String headerContent, Consumer<String> valueCallback, Consumer<Float> weightCallback, BiConsumer<String, String> parameterCallback) {
        int paramIndex = headerContent.indexOf(59);
        if (paramIndex < 0) {
            valueCallback.accept(headerContent);
        } else {
            valueCallback.accept(headerContent.substring(0, paramIndex));
            Matcher paramFindings = PARAMETER_FINDER.matcher(headerContent);
            while (paramFindings.find()) {
                String key = paramFindings.group("key");
                String value = HeaderParser.matchedSelector(paramFindings.group("value1"), paramFindings.group("value2"));
                if ("q".equalsIgnoreCase(key)) {
                    try {
                        if (value == null) continue;
                        weightCallback.accept(Float.valueOf(Float.parseFloat(value)));
                    }
                    catch (NumberFormatException e) {
                        log.info((Object)"Found a \"q\" parameter with value \"{}\" which was unparsable", new Object[]{value});
                    }
                    continue;
                }
                parameterCallback.accept(key, value);
            }
        }
    }

    public static void parseMIME(String headerContent, Consumer<String> componentCallback, Consumer<String> subcomponentCallback) {
        int slashIndex = headerContent.indexOf(47);
        int paramIndex = headerContent.indexOf(59, slashIndex + 1);
        if (slashIndex < 0) {
            componentCallback.accept("*");
        } else {
            componentCallback.accept(headerContent.substring(0, slashIndex));
        }
        if (paramIndex < 0) {
            subcomponentCallback.accept(headerContent.substring(slashIndex + 1));
        } else {
            subcomponentCallback.accept(headerContent.substring(slashIndex + 1, paramIndex));
        }
    }

    public static String[] parseLanguageValue(String value) {
        return HYPHEN_SPLITTER.split(value.trim(), 9);
    }
}

