/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.handler.CookieHandler;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Test;

public class CSRFHandlerTest
extends WebTestBase {
    String tmpCookie;

    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testGetCookie() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra"));
        this.router.get().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(1L, cookies.size());
            this.assertEquals("XSRF-TOKEN", ((String)cookies.get(0)).substring(0, ((String)cookies.get(0)).indexOf(61)));
        }, 200, "OK", null);
    }

    @Test
    public void testPostWithoutHeader() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", null, null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithHeader() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            String cookie = (String)cookies.get(0);
            this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", this.tmpCookie), null, 200, "OK", null);
    }

    @Test
    public void testPostWithExpiredCookie() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra").setTimeout(1L));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.POST, "/", req -> req.putHeader("X-XSRF-TOKEN", "4CYp9vQsr2VSQEsi/oVsMu35Ho9TlR0EovcYovlbiBw=.1437037602082.41jwU0FPl/n7ZNZAZEA07GyIUnpKSTKQ8Eju7Nicb34="), null, 403, "Forbidden", null);
    }

    @Test
    public void testPostWithFormAttribute() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            List cookies = resp.headers().getAll("set-cookie");
            String cookie = (String)cookies.get(0);
            this.tmpCookie = cookie.substring(cookie.indexOf(61) + 1);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.tmpCookie + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, null, 200, "OK", null);
    }

    @Test
    public void testPostWithFormAttributeWithoutCookies() throws Exception {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.route().handler((Handler)CSRFHandler.create((String)"Abracadabra"));
        this.router.route().handler(rc -> {
            String token = (String)rc.get("X-XSRF-TOKEN");
            if (token != null) {
                rc.response().end(token);
            } else {
                rc.response().end();
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            resp.bodyHandler(buffer -> {
                this.tmpCookie = buffer.toString();
                latch.countDown();
            });
            List cookies = resp.headers().getAll("set-cookie");
            this.assertEquals(0L, cookies.size());
        }, 200, "OK", null);
        latch.await();
        this.testRequest(HttpMethod.POST, "/", req -> {
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + "X-XSRF-TOKEN" + "\"\r\n\r\n" + this.tmpCookie + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(str);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer);
        }, null, 200, "OK", null);
    }
}

