/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.sstore.SessionStore;
import java.text.DateFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public abstract class SessionHandlerTestBase
extends WebTestBase {
    protected SessionStore store;
    private final DateFormat dateTimeFormatter = Utils.createRFC1123DateTimeFormatter();

    @Test
    public void testSessionCookieName() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        String sessionCookieName = "acme.sillycookie";
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionCookieName(sessionCookieName));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.startsWith(sessionCookieName + "="));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieHttpOnlyFlag() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieHttpOnlyFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.indexOf("; HTTPOnly") != -1);
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieSecureFlag() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieSecureFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.indexOf("; Secure") != -1);
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieSecureFlagAndHttpOnlyFlags() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieSecureFlag(true).setCookieHttpOnlyFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.indexOf("; Secure") != -1);
            this.assertTrue(setCookie.indexOf("; HTTPOnly") != -1);
        }, 200, "OK", null);
    }

    @Test
    public void testSessionFields() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            rid.set(sess.id());
            this.assertFalse(sess.isDestroyed());
            this.assertEquals(1800000L, sess.timeout());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.startsWith("vertx-web.session="));
            int pos = setCookie.indexOf("; Path=/");
            String sessID = setCookie.substring(18, pos);
            this.assertEquals(rid.get(), sessID);
        }, 200, "OK", null);
    }

    @Test
    public void testSession() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    sess.put("eek", (Object)"wibble");
                    break;
                }
                case 2: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    this.assertEquals("wibble", sess.get("eek"));
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
    }

    @Test
    public void testSessionExpires() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        long timeout = 1000L;
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionTimeout(timeout));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        Thread.sleep(2L * (1000L + timeout));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
        CountDownLatch latch1 = new CountDownLatch(1);
        Thread.sleep(500L);
        this.store.size(this.onSuccess(res -> {
            this.assertEquals(1L, res.intValue());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        Thread.sleep(2L * (1000L + timeout));
        CountDownLatch latch2 = new CountDownLatch(1);
        this.store.size(this.onSuccess(res -> {
            this.assertEquals(0L, res.intValue());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
    }

    @Test
    public void testDestroySession() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    sess.destroy();
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                    sess.destroy();
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.store.size(this.onSuccess(res -> {
            this.assertEquals(0L, res.intValue());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
    }

    @Test
    public void testLastAccessed1() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        long start = System.currentTimeMillis();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start < 500L);
        start = System.currentTimeMillis();
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start >= 1000L);
    }

    @Test
    public void testLastAccessed2() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", (Object)"bar");
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - System.currentTimeMillis() < 500L);
    }

    @Test
    public void testIssue172_setnull() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", null);
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSessionCookieAttack() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route().handler(rc -> rc.fail(401));
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.assertNull(resp.headers().get("set-cookie")), 401, "Unauthorized", null);
    }

    protected long doTestSessionRetryTimeout() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.get("/0").handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", (Object)"foo_value");
            rc.response().end();
        });
        this.router.get("/1").handler(rc -> {
            rid.set(rc.session());
            this.assertEquals("foo_value", rc.session().get("foo"));
            rc.session().destroy();
            rc.response().end();
        });
        this.router.get("/2").handler(rc -> {
            rid.set(rc.session());
            this.assertEquals(null, rc.session().get("foo"));
            rc.response().end();
        });
        AtomicReference sessionID = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/0", req -> {}, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            sessionID.set(setCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", (String)sessionID.get()), 200, "OK", null);
        long now = System.currentTimeMillis();
        this.testRequest(HttpMethod.GET, "/2", req -> req.putHeader("cookie", (String)sessionID.get()), 200, "OK", null);
        return System.currentTimeMillis() - now;
    }

    @Test
    public void testSessionFixation() throws Exception {
        AtomicReference sessionId = new AtomicReference();
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route("/0").handler(rc -> {
            sessionId.set(rc.session().id());
            rc.response().end();
        });
        this.router.route("/1").handler(rc -> {
            this.assertEquals(sessionId.get(), rc.session().id());
            rc.session().regenerateId();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/0", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", "vertx-web.session=" + (String)sessionId.get() + "; Path=/"), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.assertFalse(("vertx-web.session=" + (String)sessionId.get() + "; Path=/").equals(setCookie));
        }, 200, "OK", null);
        CountDownLatch latch = new CountDownLatch(1);
        this.store.get((String)sessionId.get(), get -> {
            this.assertTrue(get.succeeded());
            this.assertNull(get.result());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testSessionIdLength() throws Exception {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route("/1").handler(rc -> {
            this.assertFalse("abc".equals(rc.session().id()));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", "vertx-web.session=abc; Path=/"), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
        }, 200, "OK", null);
    }
}

