/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.http.HttpMethod;
import java.util.Set;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.Handler;

/**
 * A handler which implements server side http://www.w3.org/TR/cors/[CORS] support for Vert.x-Web.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CorsHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.handler.CorsHandler.class)
public class CorsHandler implements io.vertx.core.Handler<RoutingContext> {

  public static final io.vertx.lang.reactivex.TypeArg<CorsHandler> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new CorsHandler((io.vertx.ext.web.handler.CorsHandler) obj),
    CorsHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CorsHandler delegate;
  
  public CorsHandler(io.vertx.ext.web.handler.CorsHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.CorsHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Create a CORS handler
   * @param allowedOriginPattern the allowed origin pattern
   * @return the handler
   */
  public static CorsHandler create(String allowedOriginPattern) { 
    CorsHandler ret = CorsHandler.newInstance(io.vertx.ext.web.handler.CorsHandler.create(allowedOriginPattern));
    return ret;
  }

  /**
   * Add an allowed method
   * @param method the method to add
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler allowedMethod(HttpMethod method) { 
    delegate.allowedMethod(method);
    return this;
  }

  /**
   * Add an allowed header
   * @param headerName the allowed header name
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler allowedHeader(String headerName) { 
    delegate.allowedHeader(headerName);
    return this;
  }

  /**
   * Add a set of allowed headers
   * @param headerNames the allowed header names
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler allowedHeaders(Set<String> headerNames) { 
    delegate.allowedHeaders(headerNames);
    return this;
  }

  /**
   * Add an exposed header
   * @param headerName the exposed header name
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler exposedHeader(String headerName) { 
    delegate.exposedHeader(headerName);
    return this;
  }

  /**
   * Add a set of exposed headers
   * @param headerNames the exposed header names
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler exposedHeaders(Set<String> headerNames) { 
    delegate.exposedHeaders(headerNames);
    return this;
  }

  /**
   * Set whether credentials are allowed. Note that user agents will block
   * requests that use a wildcard as origin and include credentials.
   *
   * From the MDN documentation you can read:
   *
   * <blockquote>
   * Important note: when responding to a credentialed request,
   * server must specify a domain, and cannot use wild carding.
   * </blockquote>
   * @param allow true if allowed
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler allowCredentials(boolean allow) { 
    delegate.allowCredentials(allow);
    return this;
  }

  /**
   * Set how long the browser should cache the information
   * @param maxAgeSeconds max age in seconds
   * @return a reference to this, so the API can be used fluently
   */
  public CorsHandler maxAgeSeconds(int maxAgeSeconds) { 
    delegate.maxAgeSeconds(maxAgeSeconds);
    return this;
  }


  public static  CorsHandler newInstance(io.vertx.ext.web.handler.CorsHandler arg) {
    return arg != null ? new CorsHandler(arg) : null;
  }
}
