/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.auth.htdigest.HtdigestAuth;
import io.vertx.reactivex.ext.auth.User;
import java.util.Set;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An auth handler that provides HTTP Basic Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.DigestAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.handler.DigestAuthHandler.class)
public class DigestAuthHandler implements AuthHandler, io.vertx.core.Handler<RoutingContext> {

  public static final io.vertx.lang.reactivex.TypeArg<DigestAuthHandler> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new DigestAuthHandler((io.vertx.ext.web.handler.DigestAuthHandler) obj),
    DigestAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.DigestAuthHandler delegate;
  
  public DigestAuthHandler(io.vertx.ext.web.handler.DigestAuthHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.DigestAuthHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  public Single<JsonObject> rxParseCredentials(RoutingContext context) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      parseCredentials(context, handler);
    });
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  public void authorize(User user, Handler<AsyncResult<Void>> handler) { 
    delegate.authorize(user.getDelegate(), handler);
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  public Completable rxAuthorize(User user) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      authorize(user, handler);
    });
  }

  /**
   * Create a digest auth handler
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static DigestAuthHandler create(HtdigestAuth authProvider) { 
    DigestAuthHandler ret = DigestAuthHandler.newInstance(io.vertx.ext.web.handler.DigestAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a digest auth handler, specifying the expire timeout for nonces.
   * @param authProvider the auth service to use
   * @param nonceExpireTimeout the nonce expire timeout in milliseconds.
   * @return the auth handler
   */
  public static DigestAuthHandler create(HtdigestAuth authProvider, long nonceExpireTimeout) { 
    DigestAuthHandler ret = DigestAuthHandler.newInstance(io.vertx.ext.web.handler.DigestAuthHandler.create(authProvider.getDelegate(), nonceExpireTimeout));
    return ret;
  }


  public static  DigestAuthHandler newInstance(io.vertx.ext.web.handler.DigestAuthHandler arg) {
    return arg != null ? new DigestAuthHandler(arg) : null;
  }
}
