/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.sstore;

import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.impl.AsyncResultMaybe;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.ext.web.Session;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public void get(String id, final Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.get(id, new Handler<AsyncResult<io.vertx.ext.web.Session>>(){

            public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Session.newInstance((io.vertx.ext.web.Session)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Maybe<Session> rxGet(String id) {
        return new AsyncResultMaybe(handler -> this.get(id, (Handler<AsyncResult<Session>>)handler));
    }

    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.delete(id, resultHandler);
    }

    public Single<Boolean> rxDelete(String id) {
        return new AsyncResultSingle(handler -> this.delete(id, (Handler<AsyncResult<Boolean>>)handler));
    }

    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.put(session.getDelegate(), resultHandler);
    }

    public Single<Boolean> rxPut(Session session) {
        return new AsyncResultSingle(handler -> this.put(session, (Handler<AsyncResult<Boolean>>)handler));
    }

    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.clear(resultHandler);
    }

    public Single<Boolean> rxClear() {
        return new AsyncResultSingle(handler -> this.clear((Handler<AsyncResult<Boolean>>)handler));
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.delegate.size(resultHandler);
    }

    public Single<Integer> rxSize() {
        return new AsyncResultSingle(handler -> this.size((Handler<AsyncResult<Integer>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

