/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;

class RawWebSocketTransport {
    private static final Logger log = LoggerFactory.getLogger(RawWebSocketTransport.class);

    RawWebSocketTransport(Vertx vertx, Router router, Handler<SockJSSocket> sockHandler) {
        String wsRE = "/websocket";
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> {
            ServerWebSocket ws = rc.request().upgrade();
            RawWSSockJSSocket sock = new RawWSSockJSSocket(vertx, rc.session(), rc.user(), ws);
            sockHandler.handle((Object)sock);
        }));
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> rc.response().setStatusCode(400).end("Can \"Upgrade\" only to \"WebSocket\".")));
        router.get(wsRE).handler((Handler<RoutingContext>)((Handler)rc -> rc.response().putHeader("Allow", "GET").setStatusCode(405).end()));
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        ServerWebSocket ws;
        MultiMap headers;

        RawWSSockJSSocket(Vertx vertx, Session webSession, User webUser, ServerWebSocket ws) {
            super(vertx, webSession, webUser);
            this.ws = ws;
            ws.closeHandler(v -> RawWSSockJSSocket.super.close());
        }

        @Override
        public SockJSSocket handler(Handler<Buffer> handler) {
            this.ws.binaryMessageHandler(handler);
            this.ws.textMessageHandler(textMessage -> handler.handle((Object)Buffer.buffer((String)textMessage)));
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public SockJSSocket write(Buffer data) {
            this.ws.writeBinaryMessage(data);
            return this;
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler(endHandler);
            return this;
        }

        @Override
        public void close() {
            super.close();
            this.ws.close();
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.ws.remoteAddress();
        }

        @Override
        public SocketAddress localAddress() {
            return this.ws.localAddress();
        }

        @Override
        public MultiMap headers() {
            if (this.headers == null) {
                this.headers = BaseTransport.removeCookieHeaders(this.ws.headers());
            }
            return this.headers;
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }
    }
}

