/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.Handler;

/**
 * A handler which decodes cookies from the request, makes them available in the 
 * and writes them back in the response.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CookieHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.handler.CookieHandler.class)
public class CookieHandler implements io.vertx.core.Handler<RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CookieHandler that = (CookieHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<CookieHandler> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new CookieHandler((io.vertx.ext.web.handler.CookieHandler) obj),
    CookieHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CookieHandler delegate;
  
  public CookieHandler(io.vertx.ext.web.handler.CookieHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.CookieHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Create a cookie handler
   * @return the cookie handler
   */
  public static CookieHandler create() { 
    CookieHandler ret = CookieHandler.newInstance(io.vertx.ext.web.handler.CookieHandler.create());
    return ret;
  }


  public static  CookieHandler newInstance(io.vertx.ext.web.handler.CookieHandler arg) {
    return arg != null ? new CookieHandler(arg) : null;
  }
}
