/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.ext.web.impl.Utils;
import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testNoLeadingSlash() throws Exception {
        Assert.assertEquals((Object)"/path/with/no/leading/slash", (Object)Utils.normalizePath((String)"path/with/no/leading/slash"));
    }

    @Test
    public void testNullPath() throws Exception {
        Assert.assertEquals((Object)"/", (Object)Utils.normalizePath(null));
    }

    @Test
    public void testPathWithSpaces1() throws Exception {
        Assert.assertEquals((Object)"/foo+blah/eek", (Object)Utils.normalizePath((String)"/foo+blah/eek"));
    }

    @Test
    public void testPathWithSpaces2() throws Exception {
        Assert.assertEquals((Object)"/foo%20blah/eek", (Object)Utils.normalizePath((String)"/foo%20blah/eek"));
    }

    @Test
    public void testDodgyPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"/foo/../../blah"));
    }

    @Test
    public void testDodgyPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"/foo/../../../blah"));
    }

    @Test
    public void testDodgyPath3() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"/foo/../blah"));
    }

    @Test
    public void testDodgyPath4() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"/../blah"));
    }

    @Test
    public void testMultipleSlashPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"//blah"));
    }

    @Test
    public void testMultipleSlashPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"///blah"));
    }

    @Test
    public void testMultipleSlashPath3() throws Exception {
        Assert.assertEquals((Object)"/foo/blah", (Object)Utils.normalizePath((String)"/foo//blah"));
    }

    @Test
    public void testMultipleSlashPath4() throws Exception {
        Assert.assertEquals((Object)"/foo/blah/", (Object)Utils.normalizePath((String)"/foo//blah///"));
    }

    @Test
    public void testSlashesAndDodgyPath1() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"//../blah"));
    }

    @Test
    public void testSlashesAndDodgyPath2() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"/..//blah"));
    }

    @Test
    public void testSlashesAndDodgyPath3() throws Exception {
        Assert.assertEquals((Object)"/blah", (Object)Utils.normalizePath((String)"//..//blah"));
    }

    @Test
    public void testDodgyPathEncoded() throws Exception {
        Assert.assertEquals((Object)"/..%2Fblah", (Object)Utils.normalizePath((String)"/%2E%2E%2Fblah"));
    }

    @Test
    public void testTrailingSlash() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)Utils.normalizePath((String)"/blah/"));
    }

    @Test
    public void testMultipleTrailingSlashes1() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)Utils.normalizePath((String)"/blah//"));
    }

    @Test
    public void testMultipleTrailingSlashes2() throws Exception {
        Assert.assertEquals((Object)"/blah/", (Object)Utils.normalizePath((String)"/blah///"));
    }

    @Test
    public void testBadURL() throws Exception {
        try {
            Utils.normalizePath((String)"/%7B%channel%%7D");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testURLDecode() throws Exception {
        Assert.assertEquals((Object)"/%20%21%22%23%24%25%26%27%28%29%2A%2B%2C-.%2F0123456789%3A%3B%3C%3D%3E%3F%40ABCDEFGHIJKLMNOPQRSTUVWXYZ%5B%5C%5D%5E_%60abcdefghijklmnopqrstuvwxyz%7B%7C%7D~", (Object)Utils.normalizePath((String)"/%20%21%22%23%24%25%26%27%28%29%2A%2B%2C%2D%2E%2F%30%31%32%33%34%35%36%37%38%39%3A%3B%3C%3D%3E%3F%40%41%42%43%44%45%46%47%48%49%4A%4B%4C%4D%4E%4F%50%51%52%53%54%55%56%57%58%59%5A%5B%5C%5D%5E%5F%60%61%62%63%64%65%66%67%68%69%6A%6B%6C%6D%6E%6F%70%71%72%73%74%75%76%77%78%79%7A%7B%7C%7D%7E"));
        Assert.assertEquals((Object)"/ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", (Object)Utils.urlDecode((String)Utils.normalizePath((String)"/%20%21%22%23%24%25%26%27%28%29%2A%2B%2C%2D%2E%2F%30%31%32%33%34%35%36%37%38%39%3A%3B%3C%3D%3E%3F%40%41%42%43%44%45%46%47%48%49%4A%4B%4C%4D%4E%4F%50%51%52%53%54%55%56%57%58%59%5A%5B%5C%5D%5E%5F%60%61%62%63%64%65%66%67%68%69%6A%6B%6C%6D%6E%6F%70%71%72%73%74%75%76%77%78%79%7A%7B%7C%7D%7E"), (boolean)false));
    }

    @Test
    public void testURLDecodeNonLatin() throws Exception {
        Assert.assertEquals((Object)"/foo/%C3%B1/blah/%E5%A9%B4%E5%84%BF%E6%9C%8D%E9%A5%B0/eek/%E0%B8%8C", (Object)Utils.normalizePath((String)"/foo/%C3%B1/blah/%E5%A9%B4%E5%84%BF%E6%9C%8D%E9%A5%B0/eek/%E0%B8%8C"));
        Assert.assertEquals((Object)"/foo/\u00f1/blah/\u5a74\u513f\u670d\u9970/eek/\u0e0c", (Object)Utils.urlDecode((String)Utils.normalizePath((String)"/foo/%C3%B1/blah/%E5%A9%B4%E5%84%BF%E6%9C%8D%E9%A5%B0/eek/%E0%B8%8C"), (boolean)false));
    }

    @Test
    public void testDoubleDot() throws Exception {
        Assert.assertEquals((Object)"/foo/bar/abc..def", (Object)Utils.normalizePath((String)"/foo/bar/abc..def"));
    }

    @Test
    public void testSpec() throws Exception {
        Assert.assertEquals((Object)"/a/g", (Object)Utils.normalizePath((String)"/a/b/c/./../../g"));
        Assert.assertEquals((Object)"/mid/6", (Object)Utils.normalizePath((String)"mid/content=5/../6"));
        Assert.assertEquals((Object)"/~username/", (Object)Utils.normalizePath((String)"/%7Eusername/"));
        Assert.assertEquals((Object)"/b/", (Object)Utils.normalizePath((String)"/b/c/.."));
    }

    @Test
    public void testSockJSEscape() throws Exception {
        Assert.assertEquals((Object)"[\"x\"]", (Object)Utils.urlDecode((String)"%5B%22x%22%5D", (boolean)true));
        Assert.assertEquals((Object)"[\"abc\"]", (Object)Utils.urlDecode((String)"%5B%22abc%22%5D", (boolean)true));
        Assert.assertEquals((Object)"[\"x", (Object)Utils.urlDecode((String)"%5B%22x", (boolean)true));
        Assert.assertEquals((Object)"[\"b\"]", (Object)Utils.urlDecode((String)"%5B%22b%22%5D", (boolean)true));
    }

    @Test
    public void testEncode() throws Exception {
        String original = "ein verr+++\u00fcckter text mit Leerzeichen, Plus und Umlauten";
        String encoded = URLEncoder.encode(original, "UTF-8");
        Assert.assertEquals((Object)original, (Object)Utils.urlDecode((String)encoded, (boolean)true));
    }
}

