/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WebTestWithWebClientBase
extends WebTestBase {
    public WebClient webClient;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.webClient = WebClient.wrap((HttpClient)this.client, (WebClientOptions)new WebClientOptions().setConnectTimeout(Integer.MAX_VALUE).setIdleTimeout(Integer.MAX_VALUE));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.webClient != null) {
            try {
                this.webClient.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    public void testRequestWithJSON(HttpMethod method, String path, JsonObject jsonObject, int statusCode, String statusMessage) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.webClient.request(method, 8080, "localhost", path).putHeader("content-type", "application/json").sendJsonObject(jsonObject, ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithJSON(HttpMethod method, String path, JsonObject jsonObject, int statusCode, String statusMessage, JsonObject obj) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.webClient.request(method, 8080, "localhost", path).putHeader("content-type", "application/json").sendJsonObject(jsonObject, ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            this.assertEquals(obj, ((HttpResponse)ar.result()).bodyAsJsonObject());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithJSONArray(HttpMethod method, String path, JsonArray jsonArray, int statusCode, String statusMessage, JsonArray arr) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.webClient.request(method, 8080, "localhost", path).sendJson((Object)jsonArray, ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            this.assertEquals(arr, ((HttpResponse)ar.result()).bodyAsJsonArray());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithJSONAndCustomContentType(HttpMethod method, String path, String contentType, JsonObject jsonObject, int statusCode, String statusMessage, JsonObject obj) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.webClient.request(method, 8080, "localhost", path).putHeader("content-type", contentType).sendBuffer(jsonObject.toBuffer(), ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            this.assertEquals(obj, ((HttpResponse)ar.result()).bodyAsJsonObject());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithForm(HttpMethod method, String path, FormType formType, MultiMap formMap, int statusCode, String statusMessage) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpRequest request = this.webClient.request(method, 8080, "localhost", path);
        request.putHeader("Content-Type", formType.headerValue).sendForm(formMap, ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithResponseContentTypeCheck(HttpMethod method, String path, int statusCode, String contentType, List<String> acceptableContentTypes) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpRequest request = this.webClient.request(method, 8080, "localhost", path);
        request.putHeader("Accept", String.join((CharSequence)", ", acceptableContentTypes));
        request.send(httpResponseAsyncResult -> {
            if (httpResponseAsyncResult.succeeded()) {
                this.assertEquals(((HttpResponse)httpResponseAsyncResult.result()).statusCode(), statusCode);
                this.assertEquals(((HttpResponse)httpResponseAsyncResult.result()).getHeader("content-type"), contentType);
            }
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public static enum FormType {
        MULTIPART("multipart/form-data"),
        FORM_URLENCODED("application/x-www-form-urlencoded");

        public String headerValue;

        private FormType(String headerValue) {
            this.headerValue = headerValue;
        }
    }
}

