/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.TestUtils;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class EventbusBridgeTest
extends WebTestBase {
    protected SockJSHandler sockJSHandler;
    protected BridgeOptions defaultOptions = new BridgeOptions();
    protected BridgeOptions allAccessOptions = new BridgeOptions().addInboundPermitted(new PermittedOptions()).addOutboundPermitted(new PermittedOptions());
    protected String websocketURI = "/eventbus/websocket";
    protected String addr = "someaddress";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sockJSHandler = SockJSHandler.create((Vertx)this.vertx);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
    }

    @Test
    public void testHookCreateSocket() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CREATED) {
                this.assertNotNull(be.socket());
                this.assertNull(be.getRawMessage());
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend("foobar");
        this.await();
    }

    @Test
    public void testHookCreateSocketRejected() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CREATED) {
                be.complete((Object)false);
                latch.countDown();
            } else {
                be.complete((Object)true);
            }
        });
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg = new JsonObject().put("type", "send").put("address", this.addr).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.closeHandler(v -> latch.countDown());
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testHookSocketClosed() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SOCKET_CLOSED) {
                this.assertNotNull(be.socket());
                this.assertNull(be.getRawMessage());
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.client.websocket(this.websocketURI, WebSocketBase::close);
        this.await();
    }

    @Test
    public void testHookSend() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend("foobar");
        this.await();
    }

    @Test
    public void testHookSendHeaders() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                raw.put("headers", new JsonObject().put("hdr1", "val1").put("hdr2", "val2"));
                be.setRawMessage(raw);
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testSend(this.addr, "foobar", true);
        this.await();
    }

    @Test
    public void testHookSendRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "foobar"), "rejected");
        this.await();
    }

    @Test
    public void testHookSendMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.SEND) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookPublish() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testPublish("foobar");
        this.await();
    }

    @Test
    public void testHookPublishHeaders() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                raw.put("headers", new JsonObject().put("hdr1", "val1").put("hdr2", "val2"));
                be.setRawMessage(raw);
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testPublish(this.addr, "foobar", true);
        this.await();
    }

    @Test
    public void testHookPubRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", "publish").put("address", this.addr).put("body", "foobar"), "rejected");
        this.await();
    }

    @Test
    public void testHookPublishMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.PUBLISH) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", "publish").put("address", this.addr).put("body", "foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookRegister() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceive("foobar");
        this.await();
    }

    @Test
    public void testHookRegisterRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", "register").put("address", this.addr), "rejected");
        this.await();
    }

    @Test
    public void testHookRegisterMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.REGISTER) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", "register").put("address", this.addr).put("body", "foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testHookReceive() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.RECEIVE) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                this.assertEquals("foobar", raw.getString("body"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceive("foobar");
        this.await();
    }

    @Test
    public void testHookReceiveRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.RECEIVE) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testReceiveFail(this.addr, "foobar");
        this.await();
    }

    @Test
    public void testHookUnregister() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                this.assertNotNull(be.socket());
                JsonObject raw = be.getRawMessage();
                this.assertEquals(this.addr, raw.getString("address"));
                be.complete((Object)true);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testUnregister(this.addr);
        this.await();
    }

    @Test
    public void testHookUnregisterRejected() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                be.complete((Object)false);
                this.testComplete();
            } else {
                be.complete((Object)true);
            }
        });
        this.testError(new JsonObject().put("type", "unregister").put("address", this.addr), "rejected");
        this.await();
    }

    @Test
    public void testHookUnregisterMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions, be -> {
            if (be.type() == BridgeEventType.UNREGISTER) {
                be.getRawMessage().remove("address");
                this.testComplete();
            }
            be.complete((Object)true);
        });
        this.testError(new JsonObject().put("type", "unregister").put("address", this.addr).put("body", "foobar"), "missing_address");
        this.await();
    }

    @Test
    public void testSendStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend("foobar");
    }

    @Test
    public void testSendJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(new JsonObject().put("foo", "bar").put("blah", Integer.valueOf(123)));
    }

    @Test
    public void testSendJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(new JsonArray().add("foo").add(Integer.valueOf(1456)));
    }

    @Test
    public void testSendNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(13456);
    }

    @Test
    public void testSendBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(true);
    }

    @Test
    public void testSendBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testSend(false);
    }

    @Test
    public void testPublishStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish("foobar");
    }

    @Test
    public void testPublishJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(new JsonObject().put("foo", "bar").put("blah", Integer.valueOf(123)));
    }

    @Test
    public void testPublishJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(new JsonArray().add("foo").add(Integer.valueOf(1456)));
    }

    @Test
    public void testPublishNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(13456);
    }

    @Test
    public void testPublishBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(true);
    }

    @Test
    public void testPublishBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testPublish(false);
    }

    @Test
    public void testReceiveStringAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive("foobar");
    }

    @Test
    public void testReceiveJsonObjectAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(new JsonObject().put("foo", "bar").put("blah", Integer.valueOf(123)));
    }

    @Test
    public void testReceiveJsonArrayAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(new JsonArray().add("foo").add(Integer.valueOf(1456)));
    }

    @Test
    public void testReceiveNumberAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(13456);
    }

    @Test
    public void testReceiveBooleanTrueAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(true);
    }

    @Test
    public void testReceiveBooleanFalseAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testReceive(false);
    }

    @Test
    public void testUnregisterAllAccess() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testUnregister("someaddress");
    }

    @Test
    public void testInvalidType() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", "wibble").put("address", "addr"), "invalid_type");
    }

    @Test
    public void testInvalidJson() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError("oqiwjdioqwjdoiqjwd", "invalid_json");
    }

    @Test
    public void testMissingType() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("address", "someaddress"), "missing_type");
    }

    @Test
    public void testMissingAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", "send").put("body", "hello world"), "missing_address");
    }

    @Test
    public void testSendNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "hello world"), "access_denied");
    }

    @Test
    public void testSendPermittedAllowAddress() throws Exception {
        String addr = "allow1";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr)));
        this.testSend(addr, "foobar");
        this.testError(new JsonObject().put("type", "send").put("address", "allow2").put("body", "blah"), "access_denied");
    }

    @Test
    public void testSendPermittedAllowAddressRe() throws Exception {
        String addr = "allo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddressRegex(addr)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testError(new JsonObject().put("type", "send").put("address", "hello").put("body", "blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMultipleAddresses() throws Exception {
        String addr1 = "allow1";
        String addr2 = "allow2";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr1)).addInboundPermitted(new PermittedOptions().setAddress(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testError(new JsonObject().put("type", "send").put("address", "allow3").put("body", "blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMultipleAddressRe() throws Exception {
        String addr1 = "allo.+";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddressRegex(addr1)).addInboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("allow2", "foobar");
        this.testSend("ballow1", "foobar");
        this.testSend("ballow2", "foobar");
        this.testError(new JsonObject().put("type", "send").put("address", "hello").put("body", "blah"), "access_denied");
    }

    @Test
    public void testSendPermittedMixedAddressRe() throws Exception {
        String addr1 = "allow1";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(addr1)).addInboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testSend("allow1", "foobar");
        this.testSend("ballow1", "foobar");
        this.testSend("ballow2", "foobar");
        this.testError(new JsonObject().put("type", "send").put("address", "hello").put("body", "blah"), "access_denied");
        this.testError(new JsonObject().put("type", "send").put("address", "allow2").put("body", "blah"), "access_denied");
    }

    @Test
    public void testSendPermittedStructureMatch() throws Exception {
        JsonObject match = new JsonObject().put("fib", "wib").put("oop", Integer.valueOf(12));
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setMatch(match)));
        this.testSend(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", "foob");
        this.testSend(this.addr, json1);
        json1.remove("fib");
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", json1), "access_denied");
    }

    @Test
    public void testSendPermittedStructureMatchWithAddress() throws Exception {
        JsonObject match = new JsonObject().put("fib", "wib").put("oop", Integer.valueOf(12));
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setMatch(match).setAddress(this.addr)));
        this.testSend(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", "foob");
        this.testSend(this.addr, json1);
        json1.remove("fib");
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", json1), "access_denied");
        this.testError(new JsonObject().put("type", "send").put("address", "otheraddress").put("body", json1), "access_denied");
    }

    @Test
    public void testRegisterPermittedAllowAddress() throws Exception {
        String addr = "allow1";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr)));
        this.testReceive(addr, "foobar");
        this.testError(new JsonObject().put("type", "register").put("address", "allow2").put("body", "blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedAllowAddressRe() throws Exception {
        String addr = "allo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddressRegex(addr)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testError(new JsonObject().put("type", "register").put("address", "hello").put("body", "blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMultipleAddresses() throws Exception {
        String addr1 = "allow1";
        String addr2 = "allow2";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr1)).addOutboundPermitted(new PermittedOptions().setAddress(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testError(new JsonObject().put("type", "register").put("address", "allow3").put("body", "blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMultipleAddressRe() throws Exception {
        String addr1 = "allo.+";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddressRegex(addr1)).addOutboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("allow2", "foobar");
        this.testReceive("ballow1", "foobar");
        this.testReceive("ballow2", "foobar");
        this.testError(new JsonObject().put("type", "register").put("address", "hello").put("body", "blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedMixedAddressRe() throws Exception {
        String addr1 = "allow1";
        String addr2 = "ballo.+";
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(addr1)).addOutboundPermitted(new PermittedOptions().setAddressRegex(addr2)));
        this.testReceive("allow1", "foobar");
        this.testReceive("ballow1", "foobar");
        this.testReceive("ballow2", "foobar");
        this.testError(new JsonObject().put("type", "register").put("address", "hello").put("body", "blah"), "access_denied");
        this.testError(new JsonObject().put("type", "register").put("address", "allow2").put("body", "blah"), "access_denied");
    }

    @Test
    public void testRegisterPermittedStructureMatch() throws Exception {
        JsonObject match = new JsonObject().put("fib", "wib").put("oop", Integer.valueOf(12));
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setMatch(match)));
        this.testReceive(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", "foob");
        this.testReceive(this.addr, json1);
        JsonObject json2 = json1.copy();
        json2.remove("fib");
        this.testReceiveFail(this.addr, json2);
    }

    @Test
    public void testRegisterPermittedStructureMatchWithAddress() throws Exception {
        JsonObject match = new JsonObject().put("fib", "wib").put("oop", Integer.valueOf(12));
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setMatch(match).setAddress(this.addr)));
        this.testReceive(this.addr, match);
        JsonObject json1 = match.copy();
        json1.put("blah", "foob");
        this.testReceive(this.addr, json1);
        JsonObject json2 = json1.copy();
        json2.remove("fib");
        this.testReceiveFail(this.addr, json2);
    }

    @Test
    public void testReplyMessagesInbound() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                msg.reply((Object)"barfoo");
                consumer.unregister();
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", "send").put("address", this.addr).put("replyAddress", replyAddress).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("barfoo", rec);
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyMessagesInboundWithHeaders() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                msg.reply((Object)"barfoo", new DeliveryOptions().addHeader("headfoo", "headbar").addHeader("explode", "m1").addHeader("explode", "m2"));
                consumer.unregister();
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", "send").put("address", this.addr).put("replyAddress", replyAddress).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("barfoo", rec);
                JsonObject headers = received.getJsonObject("headers");
                this.assertNotNull(headers);
                this.assertEquals("headbar", headers.getString("headfoo"));
                this.assertTrue(headers.getJsonArray("explode").contains((Object)"m1"));
                this.assertTrue(headers.getJsonArray("explode").contains((Object)"m2"));
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyMessagesOutbound() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addOutboundPermitted(new PermittedOptions().setAddress(this.addr)));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject reg = new JsonObject().put("type", "register").put("address", this.addr);
            ws.writeFrame(WebSocketFrame.textFrame((String)reg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("foobar", rec);
                JsonObject reply = new JsonObject().put("type", "send").put("address", received.getString("replyAddress")).put("body", "barfoo");
                ws.writeFrame(WebSocketFrame.textFrame((String)reply.encode(), (boolean)true));
            });
            this.vertx.setTimer(500L, tid -> this.vertx.eventBus().send(this.addr, (Object)"foobar", res -> {
                if (res.succeeded()) {
                    this.assertEquals("barfoo", ((Message)res.result()).body());
                    ws.closeHandler(v2 -> latch.countDown());
                    ws.close();
                }
            }));
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testReplyToClientTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setReplyTimeout(200L));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("foobar", receivedBody);
                this.vertx.setTimer(500L, tid -> {
                    msg.reply((Object)"barfoo");
                    consumer.unregister();
                });
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", "send").put("address", this.addr).put("replyAddress", replyAddress).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("failureType");
                this.assertEquals("TIMEOUT", rec);
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testAwaitingReplyToClientTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setReplyTimeout(200L));
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(this.addr);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals("one", receivedBody);
                msg.reply((Object)"two", rep -> {
                    this.assertTrue(rep.succeeded());
                    Object repReceivedBody = ((Message)rep.result()).body();
                    this.assertEquals("three", repReceivedBody);
                    this.vertx.setTimer(500L, tid -> {
                        ((Message)rep.result()).reply((Object)"four");
                        consumer.unregister();
                    });
                });
            });
            String replyAddress = UUID.randomUUID().toString();
            JsonObject msg2 = new JsonObject().put("type", "send").put("address", this.addr).put("replyAddress", replyAddress).put("body", "one");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                this.assertEquals("two", rec);
                String secondReplyAddress = UUID.randomUUID().toString();
                JsonObject rep_msg = new JsonObject().put("type", "send").put("address", received.getValue("replyAddress")).put("replyAddress", secondReplyAddress).put("body", "three");
                ws.writeFrame(WebSocketFrame.textFrame((String)rep_msg.encode(), (boolean)true));
                ws.handler(repBuff -> {
                    String repStr = repBuff.toString();
                    JsonObject repReceived = new JsonObject(repStr);
                    Object repRec = repReceived.getValue("failureType");
                    this.assertEquals("TIMEOUT", repRec);
                    ws.closeHandler(v -> latch.countDown());
                    ws.close();
                });
            });
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testRegisterNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", "register").put("address", this.addr), "access_denied");
    }

    @Test
    public void testUnregisterNotPermittedDefaultOptions() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions);
        this.testError(new JsonObject().put("type", "unregister").put("address", this.addr), "access_denied");
    }

    @Test
    public void testMaxHandlersPerSocket() throws Exception {
        int maxHandlers = 10;
        CountDownLatch latch = new CountDownLatch(1);
        this.sockJSHandler.bridge(new BridgeOptions(this.allAccessOptions).setMaxHandlersPerSocket(maxHandlers));
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg;
            for (int i = 0; i < maxHandlers + 1; ++i) {
                msg = new JsonObject().put("type", "register").put("address", this.addr);
                ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            }
            AtomicInteger cnt = new AtomicInteger();
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                Object rec = received.getValue("body");
                int c = cnt.getAndIncrement();
                if (c == 0) {
                    this.assertEquals("err", received.getString("type"));
                    this.assertEquals("max_handlers_reached", rec);
                } else if (c >= maxHandlers + 1) {
                    this.fail("Called too many times");
                } else {
                    this.assertEquals("rec", received.getString("type"));
                    this.assertEquals("foobar", rec);
                    if (c == maxHandlers) {
                        this.vertx.setTimer(200L, tid -> latch.countDown());
                    }
                }
            });
            msg = new JsonObject().put("type", "publish").put("address", this.addr).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testMaxAddressLength() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.sockJSHandler.bridge(new BridgeOptions(this.allAccessOptions).setMaxAddressLength(10));
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg = new JsonObject().put("type", "register").put("address", "someaddressyqgyuqwdyudyug");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("err", received.getString("type"));
                this.assertEquals("max_address_length_reached", received.getString("body"));
                latch.countDown();
            });
        });
        this.awaitLatch(latch);
    }

    @Test
    public void testSendRequiresAuthorityNotLoggedIn() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("admin")));
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "foo"), "not_logged_in");
    }

    @Test
    public void testSendRequiresAuthorityHasAuthority() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("bang_sticks")));
        this.router.clear();
        this.router.route().handler((Handler)CookieHandler.create());
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.addLoginHandler(this.router, (AuthProvider)authProvider);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
        this.testSend("foo");
    }

    @Test
    public void testSendRequiresAuthorityHasnotAuthority() throws Exception {
        this.sockJSHandler.bridge(this.defaultOptions.addInboundPermitted(new PermittedOptions().setAddress(this.addr).setRequiredAuthority("pick_nose")));
        this.router.clear();
        this.router.route().handler((Handler)CookieHandler.create());
        LocalSessionStore store = LocalSessionStore.create((Vertx)this.vertx);
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthRealmType)ShiroAuthRealmType.PROPERTIES, (JsonObject)authConfig);
        this.addLoginHandler(this.router, (AuthProvider)authProvider);
        this.router.route("/eventbus/*").handler((Handler)this.sockJSHandler);
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "foo"), "access_denied");
    }

    private void addLoginHandler(Router router, AuthProvider authProvider) {
        router.route("/eventbus/*").handler(rc -> {
            if (rc.user() == null) {
                JsonObject authInfo = new JsonObject().put("username", "tim").put("password", "delicious:sausages");
                authProvider.authenticate(authInfo, res -> {
                    if (res.succeeded()) {
                        rc.setUser((User)res.result());
                        rc.next();
                    } else {
                        rc.fail(res.cause());
                    }
                });
            }
        });
    }

    @Test
    public void testInvalidClientReplyAddress() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions);
        this.testError(new JsonObject().put("type", "send").put("address", this.addr).put("body", "foo").put("replyAddress", "thishasmorethan36characters__________"), "invalid_reply_address");
    }

    @Test
    public void testConnectionClosedAfterPingTimeout() throws Exception {
        this.sockJSHandler.bridge(this.allAccessOptions.setPingTimeout(1000L));
        CountDownLatch latch = new CountDownLatch(1);
        long start = System.currentTimeMillis();
        this.client.websocket(this.websocketURI, ws -> ws.closeHandler(v -> latch.countDown()));
        this.awaitLatch(latch);
        long dur = System.currentTimeMillis() - start;
        this.assertTrue(dur > 1000L && dur < 3000L);
    }

    @Test
    public void testPermittedOptions() {
        PermittedOptions options = new PermittedOptions();
        this.assertEquals(PermittedOptions.DEFAULT_ADDRESS, options.getAddress());
        this.assertEquals(PermittedOptions.DEFAULT_ADDRESS_REGEX, options.getAddressRegex());
        this.assertEquals(PermittedOptions.DEFAULT_REQUIRED_AUTHORITY, options.getRequiredAuthority());
        this.assertEquals(PermittedOptions.DEFAULT_MATCH, options.getMatch());
        String address = TestUtils.randomAlphaString((int)10);
        String addressRegex = TestUtils.randomAlphaString((int)10);
        String requiredAuthority = TestUtils.randomAlphaString((int)10);
        JsonObject match = new JsonObject().put(TestUtils.randomAlphaString((int)10), TestUtils.randomAlphaString((int)10));
        this.assertSame(options, options.setAddress(address));
        this.assertSame(options, options.setAddressRegex(addressRegex));
        this.assertSame(options, options.setRequiredAuthority(requiredAuthority));
        this.assertSame(options, options.setMatch(match));
        this.assertEquals(address, options.getAddress());
        this.assertEquals(addressRegex, options.getAddressRegex());
        this.assertEquals(requiredAuthority, options.getRequiredAuthority());
        this.assertEquals(match, options.getMatch());
        PermittedOptions copy = new PermittedOptions(options);
        this.assertEquals(address, copy.getAddress());
        this.assertEquals(addressRegex, copy.getAddressRegex());
        this.assertEquals(requiredAuthority, copy.getRequiredAuthority());
        this.assertEquals(match, copy.getMatch());
        this.assertSame(copy, copy.setAddress(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setAddressRegex(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setRequiredAuthority(TestUtils.randomAlphaString((int)10)));
        this.assertSame(copy, copy.setMatch(new JsonObject().put(TestUtils.randomAlphaString((int)10), TestUtils.randomAlphaString((int)10))));
        this.assertSame(options, options.setAddress(address));
        this.assertSame(options, options.setAddressRegex(addressRegex));
        this.assertSame(options, options.setRequiredAuthority(requiredAuthority));
        this.assertSame(options, options.setMatch(match));
    }

    @Test
    public void testPermittedOptionsJson() {
        String address = TestUtils.randomAlphaString((int)10);
        String addressRegex = TestUtils.randomAlphaString((int)10);
        String requiredAuthority = TestUtils.randomAlphaString((int)10);
        JsonObject match = new JsonObject().put(TestUtils.randomAlphaString((int)10), TestUtils.randomAlphaString((int)10));
        JsonObject json = new JsonObject().put("address", address).put("addressRegex", addressRegex).put("requiredAuthority", requiredAuthority).put("match", match);
        PermittedOptions options = new PermittedOptions(json);
        this.assertEquals(address, options.getAddress());
        this.assertEquals(addressRegex, options.getAddressRegex());
        this.assertEquals(requiredAuthority, options.getRequiredAuthority());
        this.assertEquals(match, options.getMatch());
    }

    private void testError(JsonObject msg, String expectedErr) throws Exception {
        this.testError(msg.encode(), expectedErr);
    }

    private void testError(String msg, String expectedErr) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            ws.writeFrame(WebSocketFrame.textFrame((String)msg, (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("err", received.getString("type"));
                this.assertEquals(expectedErr, received.getString("body"));
                latch.countDown();
            });
        });
        this.awaitLatch(latch);
    }

    private void testSend(Object body) throws Exception {
        this.testSend(this.addr, body);
    }

    private void testSend(String address, Object body) throws Exception {
        this.testSend(address, body, false);
    }

    private void testSend(String address, Object body, boolean headers) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            MessageConsumer consumer = this.vertx.eventBus().consumer(address);
            consumer.handler(msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                consumer.unregister(v -> latch.countDown());
            });
            JsonObject msg2 = new JsonObject().put("type", "send").put("address", address).put("body", body);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
        });
        this.awaitLatch(latch);
    }

    private void testPublish(Object body) throws Exception {
        this.testPublish(this.addr, body);
    }

    private void testPublish(String address, Object body) throws Exception {
        this.testPublish(address, body, false);
    }

    private void checkHeaders(Message msg) {
        this.assertEquals("val1", msg.headers().get("hdr1"));
        this.assertEquals("val2", msg.headers().get("hdr2"));
    }

    private void testPublish(String address, Object body, boolean headers) throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.client.websocket(this.websocketURI, ws -> {
            this.vertx.eventBus().consumer(address, msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                latch.countDown();
            });
            this.vertx.eventBus().consumer(address, msg -> {
                Object receivedBody = msg.body();
                this.assertEquals(body, receivedBody);
                if (headers) {
                    this.checkHeaders((Message)msg);
                }
                latch.countDown();
            });
            JsonObject msg2 = new JsonObject().put("type", "publish").put("address", address).put("body", body);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
        });
        this.awaitLatch(latch);
    }

    private void testReceive(Object body) throws Exception {
        this.testReceive("someaddress", body);
    }

    private void testReceive(String address, Object body) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg = new JsonObject().put("type", "register").put("address", address);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("rec", received.getString("type"));
                Object rec = received.getValue("body");
                this.assertEquals(body, rec);
                ws.closeHandler(v -> latch.countDown());
                ws.close();
            });
            this.vertx.setTimer(200L, tid -> this.vertx.eventBus().send(address, body));
        });
        this.awaitLatch(latch);
    }

    private void testReceiveFail(String address, Object body) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg = new JsonObject().put("type", "register").put("address", address);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> this.fail("Shouldn't receive anything"));
            this.vertx.setTimer(200L, tid -> {
                this.vertx.eventBus().send(address, body);
                this.vertx.setTimer(200L, tid2 -> latch.countDown());
            });
        });
        this.awaitLatch(latch);
    }

    private void testUnregister(String address) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.websocket(this.websocketURI, ws -> {
            JsonObject msg = new JsonObject().put("type", "register").put("address", address);
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
            ws.handler(buff -> {
                String str = buff.toString();
                JsonObject received = new JsonObject(str);
                this.assertEquals("rec", received.getString("type"));
                Object rec = received.getValue("body");
                this.assertEquals("foobar", rec);
                JsonObject msg2 = new JsonObject().put("type", "unregister").put("address", address);
                ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
                msg2 = new JsonObject().put("type", "send").put("address", address).put("body", "foobar2");
                ws.writeFrame(WebSocketFrame.textFrame((String)msg2.encode(), (boolean)true));
                this.vertx.setTimer(500L, tid -> latch.countDown());
            });
            msg = new JsonObject().put("type", "send").put("address", address).put("body", "foobar");
            ws.writeFrame(WebSocketFrame.textFrame((String)msg.encode(), (boolean)true));
        });
        this.awaitLatch(latch);
    }
}

