/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.ext.web.Http2PushMapping;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.Utils;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class StaticHandlerTest
extends WebTestBase {
    private final DateFormat dateTimeFormatter = Utils.createRFC1123DateTimeFormatter();
    protected StaticHandler stat;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stat = StaticHandler.create();
        this.router.route().handler((Handler)this.stat);
    }

    @Test
    public void testGetDefaultIndex() throws Exception {
        this.testRequest(HttpMethod.GET, "/", 200, "OK", "<html><body>Index page</body></html>");
    }

    @Test
    public void testGetSubdirectorySlashDefaultIndex() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/", 200, "OK", "<html><body>Subdirectory index page</body></html>");
    }

    @Test
    public void testGetOtherIndex() throws Exception {
        this.stat.setIndexPage("otherpage.html");
        this.testRequest(HttpMethod.GET, "/", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testGetSubdirectoryOtherIndex() throws Exception {
        this.stat.setIndexPage("otherpage.html");
        this.testRequest(HttpMethod.GET, "/somedir", 200, "OK", "<html><body>Subdirectory other page</body></html>");
    }

    @Test
    public void testGetSubdirectorySlashOtherIndex() throws Exception {
        this.stat.setIndexPage("otherpage.html");
        this.testRequest(HttpMethod.GET, "/somedir", 200, "OK", "<html><body>Subdirectory other page</body></html>");
    }

    @Test
    public void testGetFileWithSpaces() throws Exception {
        this.testRequest(HttpMethod.GET, "/file%20with%20spaces.html", 200, "OK", "<html><body>File with spaces</body></html>");
    }

    @Test
    public void testGetOtherPage() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testGetPageFromSubdir() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/something.html", 200, "OK", "<html><body>Blah page</body></html>");
    }

    @Test
    public void testBadPathNoLeadingSlash() throws Exception {
        this.testRequest(HttpMethod.GET, "otherpage.html", 404, "Not Found");
    }

    @Test
    public void testGetHiddenPage() throws Exception {
        this.testRequest(HttpMethod.GET, "/.hidden.html", 200, "OK", "<html><body>Hidden page</body></html>");
    }

    @Test
    public void testCantGetHiddenPage() throws Exception {
        this.stat.setIncludeHidden(false);
        this.testRequest(HttpMethod.GET, "/.hidden.html", 404, "Not Found");
    }

    @Test
    public void testGetHiddenPageSubdir() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/.hidden.html", 200, "OK", "<html><body>Hidden page</body></html>");
    }

    @Test
    public void testCantGetHiddenPageSubdir() throws Exception {
        this.stat.setIncludeHidden(false);
        this.testRequest(HttpMethod.GET, "/somedir/.hidden.html", 404, "Not Found");
    }

    @Test
    public void testCantGetNoSuchPage() throws Exception {
        this.testRequest(HttpMethod.GET, "/notexists.html", 404, "Not Found");
    }

    @Test
    public void testCantGetNoSuchPageInSubDir() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/notexists.html", 404, "Not Found");
    }

    @Test
    public void testDateHeaderSet() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String dateHeader = res.headers().get("date");
            this.assertNotNull(dateHeader);
            long diff = System.currentTimeMillis() - this.toDateTime(dateHeader);
            this.assertTrue(diff > 0L && diff < 2000L);
        }, 200, "OK", null);
    }

    @Test
    public void testContentHeadersSet() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String contentType = res.headers().get("content-type");
            String contentLength = res.headers().get("content-length");
            this.assertEquals("text/html;charset=UTF-8", contentType);
            this.assertEquals(this.fileSize("src/test/resources/webroot/otherpage.html"), Integer.valueOf(contentLength).intValue());
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/foo.json", null, res -> {
            String contentType = res.headers().get("content-type");
            String contentLength = res.headers().get("content-length");
            this.assertEquals("application/json", contentType);
            this.assertEquals(this.fileSize("src/test/resources/webroot/foo.json"), Integer.valueOf(contentLength).intValue());
        }, 200, "OK", null);
    }

    @Test
    public void testNoLinkPreload() throws Exception {
        this.stat.setWebRoot("webroot/somedir3");
        this.testRequest(HttpMethod.GET, "/testLinkPreload.html", null, res -> {
            List linkHeaders = res.headers().getAll("Link");
            this.assertTrue(linkHeaders.isEmpty());
        }, 200, "OK", null);
    }

    @Test
    public void testLinkPreload() throws Exception {
        ArrayList<Http2PushMapping> mappings = new ArrayList<Http2PushMapping>();
        mappings.add(new Http2PushMapping("style.css", "style", false));
        mappings.add(new Http2PushMapping("coin.png", "image", false));
        this.stat.setHttp2PushMapping(mappings).setWebRoot("webroot/somedir3");
        this.testRequest(HttpMethod.GET, "/testLinkPreload.html", null, res -> {
            List linkHeaders = res.headers().getAll("Link");
            this.assertTrue(linkHeaders.contains("<style.css>; rel=preload; as=style"));
            this.assertTrue(linkHeaders.contains("<coin.png>; rel=preload; as=image"));
        }, 200, "OK", null);
    }

    @Test
    public void testNoHttp2Push() throws Exception {
        this.stat.setWebRoot("webroot/somedir3");
        this.router.route().handler((Handler)this.stat);
        HttpServer http2Server = this.vertx.createHttpServer(new HttpServerOptions().setUseAlpn(true).setSsl(true).setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath("tls/server-key.pem").setCertPath("tls/server-cert.pem")));
        http2Server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(8443);
        HttpClientOptions options = new HttpClientOptions().setSsl(true).setUseAlpn(true).setProtocolVersion(HttpVersion.HTTP_2).setPemTrustOptions(new PemTrustOptions().addCertPath("tls/server-cert.pem"));
        HttpClient client = this.vertx.createHttpClient(options);
        HttpClientRequest request = client.get(8443, "localhost", "/testLinkPreload.html", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            resp.bodyHandler(arg_0 -> ((StaticHandlerTest)this).assertNotNull(arg_0));
            this.testComplete();
        });
        request.pushHandler(pushedReq -> pushedReq.handler(pushedResp -> this.fail()));
        request.end();
        this.await();
    }

    @Test
    public void testHttp2Push() throws Exception {
        ArrayList<Http2PushMapping> mappings = new ArrayList<Http2PushMapping>();
        mappings.add(new Http2PushMapping("style.css", "style", false));
        mappings.add(new Http2PushMapping("coin.png", "image", false));
        this.stat.setHttp2PushMapping(mappings).setWebRoot("webroot/somedir3");
        this.router.route().handler((Handler)this.stat);
        HttpServer http2Server = this.vertx.createHttpServer(new HttpServerOptions().setUseAlpn(true).setSsl(true).setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath("tls/server-key.pem").setCertPath("tls/server-cert.pem")));
        http2Server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(8443);
        HttpClientOptions options = new HttpClientOptions().setSsl(true).setUseAlpn(true).setProtocolVersion(HttpVersion.HTTP_2).setPemTrustOptions(new PemTrustOptions().addCertPath("tls/server-cert.pem"));
        HttpClient client = this.vertx.createHttpClient(options);
        HttpClientRequest request = client.get(8443, "localhost", "/testLinkPreload.html", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals(HttpVersion.HTTP_2, resp.version());
            resp.bodyHandler(arg_0 -> ((StaticHandlerTest)this).assertNotNull(arg_0));
        });
        CountDownLatch latch = new CountDownLatch(2);
        request.pushHandler(pushedReq -> pushedReq.handler(pushedResp -> {
            this.assertNotNull(pushedResp);
            pushedResp.bodyHandler(arg_0 -> ((StaticHandlerTest)this).assertNotNull(arg_0));
            latch.countDown();
        }));
        request.end();
        latch.await();
    }

    @Test
    public void testHead() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.testRequest(HttpMethod.HEAD, "/otherpage.html", null, res -> {
            res.bodyHandler(buff -> this.assertEquals(0L, buff.length()));
            res.endHandler(v -> latch.countDown());
        }, 200, "OK", null);
        this.awaitLatch(latch);
    }

    @Test
    public void testCacheReturnFromCache() throws Exception {
        AtomicReference lastModifiedRef = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String cacheControl = res.headers().get("cache-control");
            String lastModified = res.headers().get("last-modified");
            lastModifiedRef.set(lastModified);
            this.assertNotNull(cacheControl);
            this.assertNotNull(lastModified);
            this.assertEquals("public, max-age=86400", cacheControl);
        }, 200, "OK", "<html><body>Other page</body></html>");
        this.testRequest(HttpMethod.GET, "/otherpage.html", req -> req.putHeader("if-modified-since", (String)lastModifiedRef.get()), null, 304, "Not Modified", null);
    }

    @Test
    public void testCacheIndexPageReturnFromCache() throws Exception {
        AtomicReference lastModifiedRef = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/somedir", null, res -> {
            String cacheControl = res.headers().get("cache-control");
            String lastModified = res.headers().get("last-modified");
            lastModifiedRef.set(lastModified);
            this.assertNotNull(cacheControl);
            this.assertNotNull(lastModified);
            this.assertEquals("public, max-age=86400", cacheControl);
        }, 200, "OK", "<html><body>Subdirectory index page</body></html>");
        this.testRequest(HttpMethod.GET, "/somedir", req -> req.putHeader("if-modified-since", (String)lastModifiedRef.get()), null, 304, "Not Modified", null);
    }

    @Test
    public void testCachingDisabled() throws Exception {
        this.stat.setCachingEnabled(false);
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String cacheControl = res.headers().get("cache-control");
            String lastModified = res.headers().get("last-modified");
            this.assertNull(cacheControl);
            this.assertNull(lastModified);
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testCacheNoCacheAsNoIfModifiedSinceHeader() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
        this.testRequest(HttpMethod.GET, "/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testCacheGetNew() throws Exception {
        AtomicReference lastModifiedRef = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String cacheControl = res.headers().get("cache-control");
            String lastModified = res.headers().get("last-modified");
            lastModifiedRef.set(lastModified);
            this.assertNotNull(cacheControl);
            this.assertNotNull(lastModified);
            this.assertEquals("public, max-age=86400", cacheControl);
        }, 200, "OK", "<html><body>Other page</body></html>");
        this.testRequest(HttpMethod.GET, "/otherpage.html", req -> req.putHeader("if-modified-since", this.dateTimeFormatter.format(this.toDateTime((String)lastModifiedRef.get()) - 1L)), res -> {}, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testSendVaryAcceptEncodingHeader() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", req -> req.putHeader("accept-encoding", "gzip"), res -> {
            String vary = res.headers().get("vary");
            this.assertNotNull(vary);
            this.assertEquals("accept-encoding", vary);
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testNoSendingOfVaryAcceptEncodingHeader() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String vary = res.headers().get("vary");
            this.assertNull(vary);
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testSetMaxAge() throws Exception {
        long maxAge = 3600L;
        this.stat.setMaxAgeSeconds(maxAge);
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String cacheControl = res.headers().get("cache-control");
            this.assertEquals("public, max-age=" + maxAge, cacheControl);
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testGetOtherPageTwice() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
        this.testRequest(HttpMethod.GET, "/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testServeFilesFromFilesystem() throws Exception {
        this.stat.setWebRoot("src/test/filesystemwebroot");
        this.testRequest(HttpMethod.GET, "/fspage.html", 200, "OK", "<html><body>File system page</body></html>");
    }

    @Test
    public void testServeFilesFromFilesystemWebRootConstructor() throws Exception {
        this.stat = StaticHandler.create((String)"src/test/filesystemwebroot");
        this.router.clear();
        this.router.route().handler((Handler)this.stat);
        this.testRequest(HttpMethod.GET, "/fspage.html", 200, "OK", "<html><body>File system page</body></html>");
    }

    @Test
    public void testCacheFilesNotReadOnly() throws Exception {
        this.stat.setFilesReadOnly(false);
        this.stat.setWebRoot("src/test/filesystemwebroot");
        long modified = Utils.secondsFactor((long)new File("src/test/filesystemwebroot", "fspage.html").lastModified());
        this.testRequest(HttpMethod.GET, "/fspage.html", null, res -> {
            String lastModified = res.headers().get("last-modified");
            this.assertEquals(modified, this.toDateTime(lastModified));
        }, 200, "OK", "<html><body>File system page</body></html>");
        this.testRequest(HttpMethod.GET, "/fspage.html", req -> req.putHeader("if-modified-since", this.dateTimeFormatter.format(modified)), null, 304, "Not Modified", null);
    }

    @Test
    public void testCacheFilesEntryCached() throws Exception {
        this.stat.setFilesReadOnly(false);
        this.stat.setWebRoot("src/test/filesystemwebroot");
        File resource = new File("src/test/filesystemwebroot", "fspage.html");
        long modified = resource.lastModified();
        this.testRequest(HttpMethod.GET, "/fspage.html", null, res -> {
            String lastModified = res.headers().get("last-modified");
            this.assertEquals(modified, this.toDateTime(lastModified));
            resource.setLastModified(modified + 1000L);
        }, 200, "OK", "<html><body>File system page</body></html>");
        this.testRequest(HttpMethod.GET, "/fspage.html", req -> req.putHeader("if-modified-since", this.dateTimeFormatter.format(modified)), null, 304, "Not Modified", null);
    }

    @Test
    public void testCacheFilesEntryOld() throws Exception {
        this.stat.setFilesReadOnly(false);
        this.stat.setWebRoot("src/test/filesystemwebroot");
        this.stat.setCacheEntryTimeout(2000L);
        File resource = new File("src/test/filesystemwebroot", "fspage.html");
        long modified = Utils.secondsFactor((long)resource.lastModified());
        this.testRequest(HttpMethod.GET, "/fspage.html", null, res -> {
            String lastModified = res.headers().get("last-modified");
            this.assertEquals(modified, this.toDateTime(lastModified));
            resource.setLastModified(modified + 1000L);
        }, 200, "OK", "<html><body>File system page</body></html>");
        Thread.sleep(2001L);
        this.testRequest(HttpMethod.GET, "/fspage.html", req -> req.putHeader("if-modified-since", this.dateTimeFormatter.format(modified)), res -> {
            String lastModified = res.headers().get("last-modified");
            this.assertEquals(modified + 1000L, this.toDateTime(lastModified));
        }, 200, "OK", "<html><body>File system page</body></html>");
    }

    @Test
    public void testDirectoryListingText() throws Exception {
        this.stat.setDirectoryListing(true);
        HashSet<String> expected = new HashSet<String>(Arrays.asList(".hidden.html", "a", "foo.json", "index.html", "otherpage.html", "somedir", "somedir2", "somedir3", "file with spaces.html"));
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            String sBuff = buff.toString();
            String[] elems = sBuff.split("\n");
            this.assertEquals(expected.size(), elems.length);
            for (String elem : elems) {
                this.assertTrue(expected.contains(elem));
            }
        }), 200, "OK", null);
    }

    @Test
    public void testDirectoryListingTextNoHidden() throws Exception {
        this.stat.setDirectoryListing(true);
        this.stat.setIncludeHidden(false);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("foo.json", "a", "index.html", "otherpage.html", "somedir", "somedir2", "somedir3", "file with spaces.html"));
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.assertEquals("text/plain", resp.headers().get("content-type"));
            String sBuff = buff.toString();
            String[] elems = sBuff.split("\n");
            this.assertEquals(expected.size(), elems.length);
            for (String elem : elems) {
                this.assertTrue(expected.contains(elem));
            }
        }), 200, "OK", null);
    }

    @Test
    public void testDirectoryListingJson() throws Exception {
        this.stat.setDirectoryListing(true);
        HashSet<String> expected = new HashSet<String>(Arrays.asList(".hidden.html", "foo.json", "index.html", "otherpage.html", "a", "somedir", "somedir2", "somedir3", "file with spaces.html"));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("accept", "application/json"), resp -> resp.bodyHandler(buff -> {
            this.assertEquals("application/json", resp.headers().get("content-type"));
            String sBuff = buff.toString();
            JsonArray arr = new JsonArray(sBuff);
            this.assertEquals(expected.size(), arr.size());
            for (Object elem : arr) {
                this.assertTrue(expected.contains(elem));
            }
            this.testComplete();
        }), 200, "OK", null);
        this.await();
    }

    @Test
    public void testDirectoryListingJsonNoHidden() throws Exception {
        this.stat.setDirectoryListing(true);
        this.stat.setIncludeHidden(false);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("foo.json", "a", "index.html", "otherpage.html", "somedir", "somedir2", "somedir3", "file with spaces.html"));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("accept", "application/json"), resp -> resp.bodyHandler(buff -> {
            this.assertEquals("application/json", resp.headers().get("content-type"));
            String sBuff = buff.toString();
            JsonArray arr = new JsonArray(sBuff);
            this.assertEquals(expected.size(), arr.size());
            for (Object elem : arr) {
                this.assertTrue(expected.contains(elem));
            }
            this.testComplete();
        }), 200, "OK", null);
        this.await();
    }

    @Test
    public void testDirectoryListingHtml() throws Exception {
        this.stat.setDirectoryListing(true);
        this.testDirectoryListingHtmlCustomTemplate("vertx-web-directory.html");
    }

    @Test
    public void testCustomDirectoryListingHtml() throws Exception {
        this.stat.setDirectoryListing(true);
        String dirTemplate = "custom_dir_template.html";
        this.stat.setDirectoryTemplate(dirTemplate);
        this.testDirectoryListingHtmlCustomTemplate(dirTemplate);
    }

    private void testDirectoryListingHtmlCustomTemplate(String dirTemplateFile) throws Exception {
        this.stat.setDirectoryListing(true);
        String directoryTemplate = Utils.readResourceToBuffer((String)dirTemplateFile).toString();
        String parentLink = "<a href=\"/\">..</a>";
        String files = "<ul id=\"files\"><li><a href=\"/somedir2/foo2.json\" title=\"foo2.json\">foo2.json</a></li><li><a href=\"/somedir2/somepage.html\" title=\"somepage.html\">somepage.html</a></li><li><a href=\"/somedir2/somepage2.html\" title=\"somepage2.html\">somepage2.html</a></li></ul>";
        String expected = directoryTemplate.replace("{directory}", "/somedir2/").replace("{parent}", parentLink).replace("{files}", files);
        this.testRequest(HttpMethod.GET, "/somedir2", req -> req.putHeader("accept", "text/html"), resp -> resp.bodyHandler(buff -> {
            this.assertEquals("text/html", resp.headers().get("content-type"));
            String sBuff = buff.toString();
            this.assertEquals(expected, sBuff);
            this.testComplete();
        }), 200, "OK", null);
        this.await();
    }

    @Test
    public void testFSBlockingTuning() throws Exception {
        this.stat.setCachingEnabled(false);
        this.stat.setMaxAvgServeTimeNs(10000L);
        for (int i = 0; i < 2000; ++i) {
            this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
                String cacheControl = res.headers().get("cache-control");
                String lastModified = res.headers().get("last-modified");
                this.assertNull(cacheControl);
                this.assertNull(lastModified);
            }, 200, "OK", "<html><body>Other page</body></html>");
        }
    }

    @Test
    public void testServerRelativeToPath() throws Exception {
        this.router.clear();
        this.router.route("/somedir/*").handler((Handler)this.stat);
        this.testRequest(HttpMethod.GET, "/somedir/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testServerRelativeToPathAndMountPoint() throws Exception {
        this.router.clear();
        Router subRouter = Router.router((Vertx)this.vertx);
        subRouter.route("/somedir/*").handler((Handler)this.stat);
        this.router.mountSubRouter("/mymount/", subRouter);
        this.testRequest(HttpMethod.GET, "/mymount/somedir/otherpage.html", 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testRangeAwareRequestHeaders() throws Exception {
        this.stat.setEnableRangeSupport(true);
        this.testRequest(HttpMethod.HEAD, "/somedir/range.jpg", null, res -> {
            this.assertEquals("bytes", res.headers().get("Accept-Ranges"));
            this.assertEquals("15783", res.headers().get("Content-Length"));
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=0-999"), res -> {
            this.assertEquals("bytes", res.headers().get("Accept-Ranges"));
            this.assertEquals("1000", res.headers().get("Content-Length"));
            this.assertEquals("bytes 0-999/15783", res.headers().get("Content-Range"));
        }, 206, "Partial Content", null);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=1000-"), res -> {
            this.assertEquals("bytes", res.headers().get("Accept-Ranges"));
            this.assertEquals("14783", res.headers().get("Content-Length"));
            this.assertEquals("bytes 1000-15782/15783", res.headers().get("Content-Range"));
        }, 206, "Partial Content", null);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=1000-5000000"), res -> {
            this.assertEquals("bytes", res.headers().get("Accept-Ranges"));
            this.assertEquals("14783", res.headers().get("Content-Length"));
            this.assertEquals("bytes 1000-15782/15783", res.headers().get("Content-Range"));
        }, 206, "Partial Content", null);
    }

    @Test
    public void testRangeAwareRequestBody() throws Exception {
        this.stat.setEnableRangeSupport(true);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=0-999"), res -> res.bodyHandler(buff -> {
            this.assertEquals("bytes", res.headers().get("Accept-Ranges"));
            this.assertEquals("1000", res.headers().get("Content-Length"));
            this.assertEquals("bytes 0-999/15783", res.headers().get("Content-Range"));
            this.assertEquals(1000L, buff.length());
            this.testComplete();
        }), 206, "Partial Content", null);
        this.await();
    }

    @Test
    public void testRangeAwareRequestBodyForDisabledRangeSupport() throws Exception {
        this.stat.setEnableRangeSupport(false);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=0-999"), res -> res.bodyHandler(buff -> {
            this.assertNull(res.headers().get("Accept-Ranges"));
            this.assertNotSame("1000", res.headers().get("Content-Length"));
            this.assertNotSame(1000, buff.length());
            this.testComplete();
        }), 200, "OK", null);
        this.await();
    }

    @Test
    public void testOutOfRangeRequestBody() throws Exception {
        this.stat.setEnableRangeSupport(true);
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> req.headers().set("Range", "bytes=15783-"), res -> res.bodyHandler(buff -> {
            this.assertEquals("bytes */15783", res.headers().get("Content-Range"));
            this.testComplete();
        }), 416, "Requested Range Not Satisfiable", null);
        this.await();
    }

    @Test
    public void testContentTypeSupport() throws Exception {
        this.testRequest(HttpMethod.GET, "/somedir/range.jpg", req -> {}, res -> {
            this.assertNotNull(res.getHeader("Content-Type"));
            this.assertEquals("image/jpeg", res.getHeader("Content-Type"));
            this.testComplete();
        }, 200, "OK", null);
        this.await();
    }

    @Test
    public void testAsyncExceptionIssue231() throws Exception {
        this.stat.setAlwaysAsyncFS(true);
        this.testRequest(HttpMethod.GET, "/non_existing.html", 404, "Not Found");
    }

    @Test
    public void testServerFileSystemPath() throws Exception {
        this.router.clear();
        File file = File.createTempFile("vertx", "tmp");
        file.deleteOnExit();
        try {
            this.stat = StaticHandler.create((String)file.getParent());
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.stat = StaticHandler.create().setAllowRootFileSystemAccess(true).setWebRoot(file.getParent());
        this.router.route().handler((Handler)this.stat);
        this.testRequest(HttpMethod.GET, "/" + file.getName(), 200, "OK", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAccessToRootPath() throws Exception {
        this.router.clear();
        File file = File.createTempFile("vertx", "tmp");
        file.deleteOnExit();
        this.stat = StaticHandler.create().setWebRoot(file.getParent());
    }

    @Test
    public void testLastModifiedInGMT() throws Exception {
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String lastModified = res.headers().get("last-modified");
            this.assertTrue(lastModified.endsWith("GMT"));
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testChangeDefaultContentEncoding() throws Exception {
        this.stat.setDefaultContentEncoding("ISO-8859-1");
        this.testRequest(HttpMethod.GET, "/otherpage.html", null, res -> {
            String contentType = res.headers().get("Content-Type");
            System.out.println(contentType);
            this.assertEquals("text/html;charset=ISO-8859-1", contentType);
        }, 200, "OK", "<html><body>Other page</body></html>");
    }

    @Test
    public void testHandlerAfter() throws Exception {
        this.router.get().handler(ctx -> ctx.response().end("Howdy!"));
        this.testRequest(HttpMethod.GET, "/not-existing-file.html", 200, "OK", "Howdy!");
    }

    private long toDateTime(String header) {
        try {
            Date date = this.dateTimeFormatter.parse(header);
            return date.getTime();
        }
        catch (Exception e) {
            this.fail(e.getMessage());
            return -1L;
        }
    }

    private long fileSize(String filename) {
        return new File(filename).length();
    }
}

