/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.TemplateHandlerImpl;
import io.vertx.ext.web.templ.TemplateEngine;
import org.junit.Test;
import org.mockito.Mockito;

public class TemplateHandlerImplTest {
    @Test
    public void testDefaultIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalisedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((RoutingContext)Mockito.any(), (String)Mockito.eq((Object)"templates"), (String)Mockito.eq((Object)"/index"), (Handler)Mockito.any());
    }

    @Test
    public void testSetIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalisedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.setIndexTemplate("home");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((RoutingContext)Mockito.any(), (String)Mockito.eq((Object)"templates"), (String)Mockito.eq((Object)"/home"), (Handler)Mockito.any());
    }

    @Test
    public void testTurnOffIndex() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalisedPath()).thenReturn((Object)"/");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.setIndexTemplate(null);
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((RoutingContext)Mockito.any(), (String)Mockito.eq((Object)"templates"), (String)Mockito.eq((Object)"/"), (Handler)Mockito.any());
    }

    @Test
    public void testSimpleTemplate() {
        TemplateEngine templateEngine = (TemplateEngine)Mockito.mock(TemplateEngine.class);
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.normalisedPath()).thenReturn((Object)"/about");
        Route currentRoute = (Route)Mockito.mock(Route.class);
        Mockito.when((Object)currentRoute.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn((Object)currentRoute);
        TemplateHandlerImpl templateHandler = new TemplateHandlerImpl(templateEngine, "templates", "ext");
        templateHandler.handle((Object)routingContext);
        ((TemplateEngine)Mockito.verify((Object)templateEngine)).render((RoutingContext)Mockito.any(), (String)Mockito.eq((Object)"templates"), (String)Mockito.eq((Object)"/about"), (Handler)Mockito.any());
    }
}

