/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Map;


@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.MIMEHeader.class)
public class MIMEHeader implements ParsedHeaderValue {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MIMEHeader that = (MIMEHeader) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<MIMEHeader> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new MIMEHeader((io.vertx.ext.web.MIMEHeader) obj),
    MIMEHeader::getDelegate
  );

  private final io.vertx.ext.web.MIMEHeader delegate;
  
  public MIMEHeader(io.vertx.ext.web.MIMEHeader delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.MIMEHeader getDelegate() {
    return delegate;
  }

  /**
   * Contains the raw value that was received from the user agent
   * @return 
   */
  public String rawValue() { 
    String ret = delegate.rawValue();
    return ret;
  }

  /**
   * Holds the unparsed value of the header.<br>
   * For the most part, this is the content before the semi-colon (";")
   * @return 
   */
  public String value() { 
    String ret = delegate.value();
    return ret;
  }

  /**
   * Holds the weight specified in the "q" parameter of the header.<br>
   * If the parameter is not specified, 1.0 is assumed according to
   * <a href="https://tools.ietf.org/html/rfc7231#section-5.3.1">rfc7231</a>
   * @return 
   */
  public float weight() { 
    float ret = delegate.weight();
    return ret;
  }

  /**
   * The value of the parameter specified by this key. Each is one of 3 things:
   * <ol>
   * <li>null &lt;- That key was not specified</li>
   * <li>ParsedHeaderValue.EMPTY (tested using ==) &lt;- The value was not specified</li>
   * <li>[Other] <- The value of the parameter</li>
   * </ol>
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @param key 
   * @return 
   */
  public String parameter(String key) { 
    String ret = delegate.parameter(key);
    return ret;
  }

  /**
   * The parameters specified in this header value.
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @return Unmodifiable Map of parameters of this header value
   */
  public Map<String,String> parameters() { 
    Map<String,String> ret = delegate.parameters();
    return ret;
  }

  /**
   * Is this an allowed operation as specified by the corresponding header?
   * @return 
   */
  public boolean isPermitted() { 
    boolean ret = delegate.isPermitted();
    return ret;
  }

  /**
   * Test if this header is matched by matchTry header
   * @param matchTry The header to be matched from
   * @return true if this header represents a subset of matchTry, otherwise, false
   */
  public boolean isMatchedBy(ParsedHeaderValue matchTry) { 
    boolean ret = delegate.isMatchedBy(matchTry.getDelegate());
    return ret;
  }

  /**
   * An integer that represents the absolute order position of this header
   * @return 
   */
  public int weightedOrder() { 
    int ret = delegate.weightedOrder();
    return ret;
  }

  /**
   * Gets the parsed component part of the MIME. This is the string between the beginning and the first <code>'/'</code>
   * of the MIME
   * @return The component of the MIME this represents
   */
  public String component() { 
    String ret = delegate.component();
    return ret;
  }

  /**
   * Gets the parsed subcomponent part of the MIME. This is the string between the first <code>'/'</code> and the
   * <code>';'</code> or the end of the MIME
   * @return The subcomponent of the MIME this represents
   */
  public String subComponent() { 
    String ret = delegate.subComponent();
    return ret;
  }


  public static  MIMEHeader newInstance(io.vertx.ext.web.MIMEHeader arg) {
    return arg != null ? new MIMEHeader(arg) : null;
  }
}
