/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.sstore;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.web.Session;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A session store is used to store sessions for an Vert.x-Web web app
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.SessionStore original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionStore that = (SessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<SessionStore> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore) obj),
    SessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.SessionStore delegate;
  
  public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.sstore.SessionStore getDelegate() {
    return delegate;
  }

  /**
   * The retry timeout value in milli seconds used by the session handler when it retrieves a value from the store.<p/>
   *
   * A non positive value means there is no retry at all.
   * @return the timeout value, in ms
   */
  public long retryTimeout() { 
    long ret = delegate.retryTimeout();
    return ret;
  }

  /**
   * Create a new session using the default min length.
   * @param timeout - the session timeout, in ms
   * @return the session
   */
  public Session createSession(long timeout) { 
    Session ret = Session.newInstance(delegate.createSession(timeout));
    return ret;
  }

  /**
   * Create a new session
   * @param timeout - the session timeout, in ms
   * @param length - the required length for the session id
   * @return the session
   */
  public Session createSession(long timeout, int length) { 
    Session ret = Session.newInstance(delegate.createSession(timeout, length));
    return ret;
  }

  /**
   * Get the session with the specified ID
   * @param id the unique ID of the session
   * @param resultHandler will be called with a result holding the session, or a failure
   */
  public void get(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.get(id, new Handler<AsyncResult<io.vertx.ext.web.Session>>() {
      public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(Session.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the session with the specified ID
   * @param id the unique ID of the session
   * @return 
   */
  public Maybe<Session> rxGet(String id) { 
    return new io.vertx.reactivex.core.impl.AsyncResultMaybe<Session>(handler -> {
      get(id, handler);
    });
  }

  /**
   * Delete the session with the specified ID
   * @param id the unique ID of the session
   * @param resultHandler will be called with a success or a failure
   */
  public void delete(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.delete(id, resultHandler);
  }

  /**
   * Delete the session with the specified ID
   * @param id the unique ID of the session
   * @return 
   */
  public Completable rxDelete(String id) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      delete(id, handler);
    });
  }

  /**
   * Add a session with the specified ID
   * @param session the session
   * @param resultHandler will be called with a success or a failure
   */
  public void put(Session session, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.put(session.getDelegate(), resultHandler);
  }

  /**
   * Add a session with the specified ID
   * @param session the session
   * @return 
   */
  public Completable rxPut(Session session) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      put(session, handler);
    });
  }

  /**
   * Remove all sessions from the store
   * @param resultHandler will be called with a success or a failure
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Remove all sessions from the store
   * @return 
   */
  public Completable rxClear() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      clear(handler);
    });
  }

  /**
   * Get the number of sessions in the store
   * @param resultHandler will be called with the number, or a failure
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Get the number of sessions in the store
   * @return 
   */
  public Single<Integer> rxSize() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Integer>(handler -> {
      size(handler);
    });
  }

  /**
   * Close the store
   */
  public void close() { 
    delegate.close();
  }


  public static  SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
    return arg != null ? new SessionStore(arg) : null;
  }
}
