/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.HashSet;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Test;

public abstract class AuthHandlerTestBase
extends WebTestBase {
    @AfterClass
    public static void oneTimeTearDown() {
        Vertx vertx = Vertx.vertx();
        if (vertx.fileSystem().existsBlocking("file-uploads")) {
            vertx.fileSystem().deleteRecursiveBlocking("file-uploads", true);
        }
    }

    @Test
    public void testAuthAuthorities() throws Exception {
        HashSet<String> authorities = new HashSet<String>();
        authorities.add("dance");
        this.testAuthorisation("tim", false, authorities);
    }

    @Test
    public void testAuthAuthoritiesFail() throws Exception {
        HashSet<String> authorities = new HashSet<String>();
        authorities.add("knitter");
        this.testAuthorisation("tim", true, authorities);
    }

    protected abstract AuthHandler createAuthHandler(AuthProvider var1);

    protected boolean requiresSession() {
        return false;
    }

    protected SessionStore getSessionStore() {
        return LocalSessionStore.create((Vertx)this.vertx);
    }

    protected void testAuthorisation(String username, boolean fail, Set<String> authorities) throws Exception {
        if (this.requiresSession()) {
            this.router.route().handler((Handler)BodyHandler.create());
            this.router.route().handler((Handler)CookieHandler.create());
            SessionStore store = this.getSessionStore();
            this.router.route().handler((Handler)SessionHandler.create((SessionStore)store));
        }
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(authConfig));
        AuthHandler authHandler = this.createAuthHandler((AuthProvider)authProvider);
        if (authorities != null) {
            authHandler.addAuthorities(authorities);
        }
        this.router.route().handler(arg_0 -> AuthHandlerTestBase.lambda$testAuthorisation$1(username, (AuthProvider)authProvider, arg_0));
        this.router.route().handler((Handler)authHandler);
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", fail ? 403 : 200, fail ? "Forbidden" : "OK");
    }

    private static /* synthetic */ void lambda$testAuthorisation$1(String username, AuthProvider authProvider, RoutingContext rc) {
        if (rc.user() == null) {
            JsonObject authInfo = new JsonObject().put("username", username).put("password", "delicious:sausages");
            authProvider.authenticate(authInfo, res -> {
                if (res.succeeded()) {
                    rc.setUser((User)res.result());
                    rc.next();
                } else {
                    rc.fail(res.cause());
                }
            });
        }
    }
}

