/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;

public abstract class SockJSTestBase
extends VertxTestBase {
    protected HttpClient client;
    protected HttpServer server;
    protected Router router;
    protected SockJSHandler sockJSHandler;

    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080));
        this.router = Router.router((Vertx)this.vertx);
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)).setNagHttps(false).setSessionTimeout(3600000L));
        this.addHandlersBeforeSockJSHandler(this.router);
        SockJSHandlerOptions options = new SockJSHandlerOptions().setHeartbeatInterval(2000L);
        this.sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)options);
        this.router.route("/test/*").handler((Handler)this.sockJSHandler);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler((Handler)this.router).listen(ar -> latch.countDown());
        this.awaitLatch(latch);
    }

    protected void addHandlersBeforeSockJSHandler(Router router) {
    }
}

