/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RoutingContextImplBase
implements RoutingContext {
    static final Logger log = LoggerFactory.getLogger(RoutingContextImplBase.class);
    private final Set<RouteImpl> routes;
    protected final String mountPoint;
    protected final HttpServerRequest request;
    protected Iterator<RouteImpl> iter;
    protected RouteImpl currentRoute;
    protected AtomicInteger currentRouteNextHandlerIndex;
    protected AtomicInteger currentRouteNextFailureHandlerIndex;

    protected RoutingContextImplBase(String mountPoint, HttpServerRequest request, Set<RouteImpl> routes) {
        this.mountPoint = mountPoint;
        this.request = new HttpServerRequestWrapper(request);
        this.routes = routes;
        this.iter = routes.iterator();
        this.currentRouteNextHandlerIndex = new AtomicInteger(0);
        this.currentRouteNextFailureHandlerIndex = new AtomicInteger(0);
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        return this.currentRoute;
    }

    protected int currentRouteNextHandlerIndex() {
        return this.currentRouteNextHandlerIndex.intValue();
    }

    protected int currentRouteNextFailureHandlerIndex() {
        return this.currentRouteNextFailureHandlerIndex.intValue();
    }

    protected void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    protected boolean iterateNext() {
        boolean failed = this.failed();
        if (this.currentRoute != null) {
            try {
                if (!failed && this.currentRoute.hasNextContextHandler(this)) {
                    this.currentRouteNextHandlerIndex.incrementAndGet();
                    this.currentRoute.handleContext(this);
                    return true;
                }
                if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                    this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                    this.currentRoute.handleFailure(this);
                    return true;
                }
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Throwable thrown from handler", t);
                }
                if (!failed) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failing the routing");
                    }
                    this.fail(t);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failure in handling failure");
                    }
                    this.unhandledFailure(-1, t, this.currentRoute.router());
                }
                return true;
            }
        }
        while (this.iter.hasNext()) {
            RouteImpl route = this.iter.next();
            this.currentRouteNextHandlerIndex.set(0);
            this.currentRouteNextFailureHandlerIndex.set(0);
            try {
                if (!route.matches(this, this.mountPoint(), failed)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Route matches: " + route));
                }
                try {
                    this.currentRoute = route;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Calling the " + (failed ? "failure" : "") + " handler"));
                    }
                    if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                        this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                        route.handleFailure(this);
                    } else {
                        if (!this.currentRoute.hasNextContextHandler(this)) continue;
                        this.currentRouteNextHandlerIndex.incrementAndGet();
                        route.handleContext(this);
                    }
                }
                catch (Throwable t) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Throwable thrown from handler", t);
                    }
                    if (!failed) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Failing the routing");
                        }
                        this.fail(t);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Failure in handling failure");
                    }
                    this.unhandledFailure(-1, t, route.router());
                }
                return true;
            }
            catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"IllegalArgumentException thrown during iteration", e);
                }
                if (!this.response().ended()) {
                    this.unhandledFailure(e instanceof IllegalArgumentException ? 400 : -1, e, route.router());
                }
                return true;
            }
        }
        return false;
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code = statusCode != -1 ? statusCode : 500;
        Handler<RoutingContext> errorHandler = router.getErrorHandlerByStatusCode(code);
        if (errorHandler != null) {
            try {
                errorHandler.handle((Object)this);
            }
            catch (Throwable t) {
                log.error((Object)"Error in error handler", t);
            }
        }
        if (!this.response().ended() && !this.response().closed()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf((int)code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }
}

