/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.StaticHandler;
import org.junit.Test;

public class StaticDirectoryListHandlerTest
extends WebTestBase {
    protected StaticHandler stat;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stat = StaticHandler.create((String)"webroot").setDirectoryListing(true).setDirectoryTemplate("custom_dir_template.html");
        this.router.route().handler((Handler)this.stat);
    }

    @Test
    public void testGetSubSubDirectory() throws Exception {
        this.testRequest(HttpMethod.GET, "/a/b/", req -> req.putHeader("Accept", "text/html"), null, 200, "OK", "<html>\n<body>\n<h1>Custom Index of /a/b/</h1>\n<a href=\"/a/\">..</a>\n<ul id=\"files\"><li><a href=\"/a/b/test.txt\" title=\"test.txt\">test.txt</a></li></ul>\n</body>\n</html>");
    }

    @Test
    public void testGetDirectory() throws Exception {
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("Accept", "text/html"), null, 200, "OK", "<html>\n<body>\n<h1>Custom Index of /</h1>\n<a href=\"/\">..</a>\n<ul id=\"files\"><li><a href=\"/.hidden.html\" title=\".hidden.html\">.hidden.html</a></li><li><a href=\"/a\" title=\"a\">a</a></li><li><a href=\"/file with spaces.html\" title=\"file with spaces.html\">file with spaces.html</a></li><li><a href=\"/foo.json\" title=\"foo.json\">foo.json</a></li><li><a href=\"/index.html\" title=\"index.html\">index.html</a></li><li><a href=\"/otherpage.html\" title=\"otherpage.html\">otherpage.html</a></li><li><a href=\"/somedir\" title=\"somedir\">somedir</a></li><li><a href=\"/somedir2\" title=\"somedir2\">somedir2</a></li><li><a href=\"/somedir3\" title=\"somedir3\">somedir3</a></li><li><a href=\"/testCompressionSuffix.html\" title=\"testCompressionSuffix.html\">testCompressionSuffix.html</a></li></ul>\n</body>\n</html>");
    }

    @Test
    public void testGetDirectoryOnSubdirMount() throws Exception {
        this.router.clear();
        this.router.route("/c/*").handler((Handler)this.stat);
        this.testRequest(HttpMethod.GET, "/c/a/b/", req -> req.putHeader("Accept", "text/html"), null, 200, "OK", "<html>\n<body>\n<h1>Custom Index of /c/a/b/</h1>\n<a href=\"/c/a/\">..</a>\n<ul id=\"files\"><li><a href=\"/c/a/b/test.txt\" title=\"test.txt\">test.txt</a></li></ul>\n</body>\n</html>");
    }

    @Test
    public void testGetDirectoryOnPrefixMount() throws Exception {
        this.router.clear();
        this.router.route("/c*").handler((Handler)this.stat);
        this.testRequest(HttpMethod.GET, "/cannot/a/b/", req -> req.putHeader("Accept", "text/html"), null, 404, "Not Found", null);
    }
}

