/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import io.vertx.ext.web.handler.ResponseTimeHandler;
import java.util.Random;
import org.junit.Test;

public class ResponseContentTypeHandlerTest
extends WebTestBase {
    private Route testRoute;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().handler((Handler)ResponseContentTypeHandler.create());
        this.router.route().handler((Handler)ResponseTimeHandler.create());
        this.testRoute = this.router.route("/test");
    }

    @Test
    public void testNoMatch() {
        this.testRoute.handler(rc -> rc.response().end());
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertNull(this.contentType((HttpClientResponse)resp));
            this.testComplete();
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    @Test
    public void testExistingHeader() {
        this.testRoute.produces("application/json").handler(rc -> rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain").end());
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertEquals("text/plain", this.contentType((HttpClientResponse)resp));
            this.testComplete();
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    @Test
    public void testFixedContent() {
        Buffer buffer = new JsonObject().put("toto", "titi").toBuffer();
        this.testRoute.produces("application/json").handler(rc -> rc.response().end(buffer));
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertEquals("application/json", this.contentType((HttpClientResponse)resp));
            this.assertEquals(buffer.length(), this.contentLength((HttpClientResponse)resp));
            resp.bodyHandler(buf -> {
                this.assertEquals(buffer, buf);
                this.testComplete();
            });
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    @Test
    public void testChunkedContent() {
        Buffer buffer = new JsonObject().put("toto", "titi").toBuffer();
        this.testRoute.produces("application/json").handler(rc -> rc.response().setChunked(true).end(buffer));
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertEquals("application/json", this.contentType((HttpClientResponse)resp));
            this.assertNull(this.contentLength((HttpClientResponse)resp));
            resp.bodyHandler(buf -> {
                this.assertEquals(buffer, buf);
                this.testComplete();
            });
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    @Test
    public void testNoContent() {
        this.testRoute.produces("application/json").handler(rc -> rc.response().end());
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertNull(this.contentType((HttpClientResponse)resp));
            this.assertEquals(0, this.contentLength((HttpClientResponse)resp));
            this.testComplete();
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    @Test
    public void testDisableFlag() {
        Random random = new Random();
        byte[] bytes = new byte[128];
        random.nextBytes(bytes);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        this.testRoute.produces("application/json").handler(rc -> {
            rc.put("__vertx.autoContenType.disable", (Object)true);
            rc.response().end(buffer);
        });
        this.client.get(this.testRoute.getPath(), resp -> {
            this.assertNull(this.contentType((HttpClientResponse)resp));
            this.assertEquals(buffer.length(), this.contentLength((HttpClientResponse)resp));
            resp.bodyHandler(buf -> {
                this.assertEquals(buffer, buf);
                this.testComplete();
            });
        }).putHeader(HttpHeaders.ACCEPT, (CharSequence)"application/json").end();
        this.await();
    }

    private String contentType(HttpClientResponse resp) {
        return resp.getHeader(HttpHeaders.CONTENT_TYPE);
    }

    private Integer contentLength(HttpClientResponse resp) {
        String header = resp.getHeader(HttpHeaders.CONTENT_LENGTH);
        return header == null ? null : Integer.valueOf(Integer.parseInt(header));
    }
}

