/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Handler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import org.junit.Test;

public class SockJSAsyncHandlerTest
extends SockJSTestBase {
    @Override
    public void setUp() throws Exception {
        this.numServers = 2;
        this.preSockJSHandlerSetup = router -> {
            router.route().handler((Handler)BodyHandler.create());
            router.route().handler(rtx -> rtx.vertx().executeBlocking(f -> f.complete((Object)true), r -> rtx.next()));
        };
        super.setUp();
    }

    @Test
    public void testHandleMessageFromXhrTransportWithAsyncHandler() throws Exception {
        this.socketHandler = () -> socket -> socket.handler(buf -> {
            this.assertEquals("Hello World", buf.toString());
            this.testComplete();
        });
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.client.post("/test/400/8ne8e94a/xhr_send", respSend -> this.assertEquals(204L, respSend.statusCode())).putHeader("content-length", "13").write("\"Hello World\"").end();
        }).end();
        this.await();
    }
}

