/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class SockJSSessionContextTest
extends SockJSTestBase {
    @Override
    public void setUp() throws Exception {
        this.numServers = 2;
        super.setUp();
    }

    @Test
    public void testHandleMessageFromXhrTransportWithAsyncHandler() throws Exception {
        String msg = "Hello World";
        this.socketHandler = () -> socket -> socket.handler(buffer -> {
            this.assertEquals(msg, buffer.toString());
            socket.write(buffer);
        });
        this.startServers();
        this.client.post("/test/400/8ne8e94a/xhr", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.client.post("/test/400/8ne8e94a/xhr", resp2 -> {
                this.assertEquals(200L, resp.statusCode());
                this.client.post("/test/400/8ne8e94a/xhr_send", respSend -> {
                    this.assertEquals(204L, respSend.statusCode());
                    this.client.post("/test/400/8ne8e94a/xhr", resp3 -> {
                        this.assertEquals(200L, resp.statusCode());
                        resp3.bodyHandler(buffer -> {
                            String body = buffer.toString();
                            this.assertThat(body, CoreMatchers.startsWith((String)"a"));
                            JsonArray content = new JsonArray(body.substring(1));
                            this.assertEquals(1L, content.size());
                            this.assertEquals(msg, content.getValue(0));
                            this.complete();
                        });
                    }).end();
                }).end('\"' + msg + '\"');
            }).end();
        }).end();
        this.await();
    }
}

