/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import org.junit.Test;

public class ChainAuthHandlerTest
extends WebTestBase {
    protected ChainAuthHandler chain;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JsonObject authConfig = new JsonObject().put("properties_path", "classpath:login/loginusers.properties");
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(authConfig));
        this.chain = ChainAuthHandler.create();
        this.chain.append((AuthHandler)JWTAuthHandler.create(null)).append(BasicAuthHandler.create((AuthProvider)authProvider)).append(RedirectAuthHandler.create((AuthProvider)authProvider));
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        this.router.route().handler((Handler)this.chain);
        this.router.route().handler(ctx -> ctx.response().end());
    }

    @Test
    public void testWithoutAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", 302, "Found", "Redirecting to /loginpage.");
    }

    @Test
    public void testWithAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcw=="), 200, "OK", "");
    }

    @Test
    public void testWithBadAuthorization() throws Exception {
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("Authorization", "Basic dGltOmRlbGljaW91czpzYXVzYWdlcX=="), 401, "Unauthorized", "Unauthorized");
    }
}

