/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.SessionStore;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.Test;

public abstract class SessionHandlerTestBase
extends WebTestBase {
    protected SessionStore store;

    @Test
    public void testSessionCookieName() throws Exception {
        String sessionCookieName = "acme.sillycookie";
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionCookieName(sessionCookieName));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.startsWith(sessionCookieName + "="));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookiePath() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionCookiePath("/path"));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.contains("Path=/path"));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieHttpOnlyFlag() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieHttpOnlyFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.contains("; HTTPOnly"));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieSecureFlag() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieSecureFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.contains("; Secure"));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionCookieSecureFlagAndHttpOnlyFlags() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setCookieSecureFlag(true).setCookieHttpOnlyFlag(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.contains("; Secure"));
            this.assertTrue(setCookie.contains("; HTTPOnly"));
        }, 200, "OK", null);
    }

    @Test
    public void testSessionFields() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            rid.set(sess.value());
            this.assertFalse(sess.isDestroyed());
            this.assertEquals(1800000L, sess.timeout());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.startsWith("vertx-web.session="));
            int pos = setCookie.indexOf("; Path=/");
            String sessID = setCookie.substring(18, pos);
            this.assertEquals(rid.get(), sessID);
        }, 200, "OK", null);
    }

    @Test
    public void testSession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    sess.put("eek", (Object)"wibble");
                    break;
                }
                case 2: {
                    this.assertEquals(rid.get(), sess.id());
                    this.assertEquals("bar", sess.get("foo"));
                    this.assertEquals("wibble", sess.get("eek"));
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            if (setCookie != null) {
                rSetCookie.set(setCookie);
            }
        }, 200, "OK", null);
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
    }

    @Test
    public void testSessionExpires() throws Exception {
        long timeout = 1000L;
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionTimeout(timeout));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    sess.put("foo", (Object)"bar");
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                }
            }
            rid.set(sess.id());
            requestCount.incrementAndGet();
            rc.response().end();
        });
        AtomicReference rSetCookie = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            rSetCookie.set(setCookie);
        }, 200, "OK", null);
        Thread.sleep(2L * (1000L + timeout));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)rSetCookie.get()), null, 200, "OK", null);
        SessionHandlerTestBase.waitUntil(() -> this.testSessionBlocking((String)rid.get(), Objects::nonNull));
        Thread.sleep(2L * (1000L + timeout));
        SessionHandlerTestBase.waitUntil(() -> this.testSessionBlocking((String)rid.get(), Objects::isNull));
    }

    private boolean testSessionBlocking(String sessionId, Function<Session, Boolean> test) {
        CompletableFuture cf = new CompletableFuture();
        this.store.get(sessionId, ar -> {
            if (ar.succeeded()) {
                cf.complete(test.apply((Session)ar.result()));
            } else {
                cf.completeExceptionally(ar.cause());
            }
        });
        try {
            return (Boolean)cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void testDestroySession() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        AtomicInteger requestCount = new AtomicInteger();
        this.router.route().handler(rc -> {
            Session sess = rc.session();
            this.assertNotNull(sess);
            this.assertTrue(System.currentTimeMillis() - sess.lastAccessed() < 500L);
            this.assertNotNull(sess.id());
            switch (requestCount.get()) {
                case 0: {
                    rid.set(sess.id());
                    sess.put("foo", (Object)"bar");
                    sess.destroy();
                    break;
                }
                case 1: {
                    this.assertFalse(((String)rid.get()).equals(sess.id()));
                    this.assertNull(sess.get("foo"));
                    rid.set(sess.id());
                    sess.destroy();
                }
            }
            requestCount.incrementAndGet();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNull(setCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", null, null, 200, "OK", null);
        Thread.sleep(500L);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.store.get((String)rid.get(), this.onSuccess(res -> {
            this.assertNull(res);
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
    }

    @Test
    public void testLastAccessed1() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        long start = System.currentTimeMillis();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start < 500L);
        start = System.currentTimeMillis();
        Thread.sleep(1000L);
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - start >= 1000L);
    }

    @Test
    public void testLastAccessed2() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", (Object)"bar");
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        this.assertTrue(((Session)rid.get()).lastAccessed() - System.currentTimeMillis() < 500L);
    }

    @Test
    public void testIssue172_setnull() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.route().handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", null);
            this.vertx.setTimer(1000L, tid -> rc.response().end());
        });
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
    }

    @Test
    public void testSessionCookieAttack() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route().handler(rc -> rc.fail(401));
        this.testRequest(HttpMethod.GET, "/", null, resp -> this.assertNull(resp.headers().get("set-cookie")), 401, "Unauthorized", null);
    }

    @Test
    public void testSessionCookieInvalidatedOnError() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        AtomicReference id = new AtomicReference();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route().handler(rc -> {
            switch (counter.getAndIncrement()) {
                case 0: {
                    id.set(rc.session().id());
                    rc.response().end();
                    break;
                }
                case 1: {
                    this.assertEquals(id.get(), rc.session().id());
                    rc.fail(500);
                    break;
                }
                case 2: {
                    this.assertEquals(id.get(), rc.session().id());
                    rc.response().end();
                }
            }
        });
        AtomicReference sessionID = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            this.assertNotNull(resp.headers().get("set-cookie"));
            String setCookie = resp.headers().get("set-cookie");
            sessionID.set(setCookie);
        }, 200, "OK", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)sessionID.get()), resp -> this.assertNull(resp.headers().get("set-cookie")), 500, "Internal Server Error", null);
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("cookie", (String)sessionID.get()), resp -> this.assertNull(resp.headers().get("set-cookie")), 200, "OK", null);
    }

    protected long doTestSessionRetryTimeout() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        AtomicReference rid = new AtomicReference();
        this.router.get("/0").handler(rc -> {
            rid.set(rc.session());
            rc.session().put("foo", (Object)"foo_value");
            rc.response().end();
        });
        this.router.get("/1").handler(rc -> {
            rid.set(rc.session());
            this.assertEquals("foo_value", rc.session().get("foo"));
            rc.session().destroy();
            rc.response().end();
        });
        this.router.get("/2").handler(rc -> {
            rid.set(rc.session());
            this.assertEquals(null, rc.session().get("foo"));
            rc.response().end();
        });
        AtomicReference sessionID = new AtomicReference();
        this.testRequest(HttpMethod.GET, "/0", req -> {}, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            sessionID.set(setCookie);
        }, 200, "OK", null);
        CountDownLatch responseReceived = new CountDownLatch(1);
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", (String)sessionID.get()), resp -> responseReceived.countDown(), 200, "OK", null);
        this.awaitLatch(responseReceived);
        long now = System.nanoTime();
        this.testRequest(HttpMethod.GET, "/2", req -> req.putHeader("cookie", (String)sessionID.get()), 200, "OK", null);
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - now, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testSessionFixation() throws Exception {
        AtomicReference sessionId = new AtomicReference();
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route("/0").handler(rc -> {
            sessionId.set(rc.session().value());
            rc.response().end();
        });
        this.router.route("/1").handler(rc -> {
            this.assertEquals(sessionId.get(), rc.session().value());
            rc.session().regenerateId();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/0", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
        }, 200, "OK", null);
        CountDownLatch responseReceived = new CountDownLatch(1);
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", "vertx-web.session=" + (String)sessionId.get() + "; Path=/"), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
            this.assertFalse(("vertx-web.session=" + (String)sessionId.get() + "; Path=/").equals(setCookie));
            responseReceived.countDown();
        }, 200, "OK", null);
        this.awaitLatch(responseReceived);
        SessionHandlerTestBase.assertWaitUntil(() -> {
            CompletableFuture cf = new CompletableFuture();
            this.store.get((String)sessionId.get(), get -> {
                if (get.succeeded()) {
                    cf.complete(get.result());
                } else {
                    cf.completeExceptionally(get.cause());
                }
            });
            try {
                return cf.get() == null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }, (long)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES), (String)"old id must not be valid anymore");
    }

    @Test
    public void testSessionIdLength() throws Exception {
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store));
        this.router.route("/1").handler(rc -> {
            this.assertFalse("abc".equals(rc.session().id()));
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/1", req -> req.putHeader("cookie", "vertx-web.session=abc; Path=/"), resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertNotNull(setCookie);
        }, 200, "OK", null);
    }

    @Test
    public void testVersion() throws Exception {
        AbstractSession session = (AbstractSession)this.store.createSession(10000L);
        this.assertEquals(0L, session.version());
        session.put("k", (Object)"v");
        this.store.put((Session)session, res -> {
            if (res.failed()) {
                this.fail("failed to store");
            }
            this.store.get(session.value(), res1 -> {
                if (res1.failed()) {
                    this.fail("failed to store");
                }
                AbstractSession session1 = (AbstractSession)res1.result();
                this.assertEquals(1L, session1.version());
                this.assertEquals("v", session1.get("k"));
                this.store.put((Session)session1, res2 -> {
                    if (res2.failed()) {
                        this.fail("failed to store");
                    }
                    this.store.get(session1.value(), res3 -> {
                        if (res3.failed()) {
                            this.fail("failed to store");
                        }
                        AbstractSession session2 = (AbstractSession)res3.result();
                        this.assertEquals(1L, session2.version());
                        this.assertEquals("v", session2.get("k"));
                        session2.put("k", (Object)"w");
                        this.store.put((Session)session2, res4 -> {
                            if (res4.failed()) {
                                this.fail("failed to store");
                            }
                            this.store.get(session2.value(), res5 -> {
                                if (res5.failed()) {
                                    this.fail("failed to store");
                                }
                                AbstractSession session3 = (AbstractSession)res5.result();
                                this.assertEquals(2L, session3.version());
                                this.assertEquals("w", session3.get("k"));
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLazySessionNotAccessed() throws Exception {
        String sessionCookieName = "acme.sillycookie";
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionCookieName(sessionCookieName).setLazySession(true));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie == null);
        }, 200, "OK", null);
    }

    @Test
    public void testLazySessionAccessed() throws Exception {
        String sessionCookieName = "acme.sillycookie";
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)this.store).setSessionCookieName(sessionCookieName).setLazySession(true));
        this.router.route().handler(rc -> {
            rc.session();
            rc.response().end();
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String setCookie = resp.headers().get("set-cookie");
            this.assertTrue(setCookie.startsWith(sessionCookieName + "="));
        }, 200, "OK", null);
    }
}

