/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.AuthHandlerTestBase;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class CustomAuthHandlerTest
extends AuthHandlerTestBase {
    @Override
    protected AuthHandler createAuthHandler(AuthProvider authProvider) {
        return this.newAuthHandler(authProvider, null);
    }

    private AuthHandler newAuthHandler(AuthProvider authProvider, final Handler<Throwable> exceptionProcessor) {
        return new AuthHandlerImpl(authProvider){

            public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
                handler.handle((Object)Future.succeededFuture((Object)new JsonObject()));
            }

            public void processException(RoutingContext ctx, Throwable exception) {
                if (exceptionProcessor != null) {
                    exceptionProcessor.handle((Object)exception);
                }
                super.processException(ctx, exception);
            }
        };
    }

    @Test
    public void testCredentialsValidationErrorPropagation() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        IllegalArgumentException rootCause = new IllegalArgumentException("validation of credentials failed");
        AuthProvider authProvider = (AuthProvider)Mockito.mock(AuthProvider.class);
        ((AuthProvider)Mockito.doAnswer(invocation -> {
            Handler resultHandler = (Handler)invocation.getArgument(1);
            resultHandler.handle((Object)Future.failedFuture((Throwable)rootCause));
            return null;
        }).when((Object)authProvider)).authenticate((JsonObject)Mockito.any(JsonObject.class), (Handler)Mockito.any(Handler.class));
        this.router.route("/protected/*").handler((Handler)this.newAuthHandler(authProvider, (Handler<Throwable>)((Handler)exception -> {
            this.assertTrue(exception instanceof HttpStatusException);
            this.assertEquals(rootCause, ((HttpStatusException)exception).getCause());
        })));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", 401, "Unauthorized");
    }

    @Test
    public void testHttpStatusExceptionFailurePropagation() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        HttpStatusException rootCause = new HttpStatusException(499, "bla");
        AuthProvider authProvider = (AuthProvider)Mockito.mock(AuthProvider.class);
        ((AuthProvider)Mockito.doAnswer(arg_0 -> CustomAuthHandlerTest.lambda$testHttpStatusExceptionFailurePropagation$4((Throwable)rootCause, arg_0)).when((Object)authProvider)).authenticate((JsonObject)Mockito.any(JsonObject.class), (Handler)Mockito.any(Handler.class));
        this.router.route("/protected/*").handler((Handler)this.newAuthHandler(authProvider, (Handler<Throwable>)((Handler)arg_0 -> this.lambda$testHttpStatusExceptionFailurePropagation$5((Throwable)rootCause, arg_0))));
        this.router.route("/protected/somepage").handler(handler);
        this.router.errorHandler(499, rc -> rc.response().setStatusCode(((HttpStatusException)rc.failure()).getStatusCode()).setStatusMessage(((HttpStatusException)rc.failure()).getPayload()).end());
        this.testRequest(HttpMethod.GET, "/protected/somepage", 499, "bla");
    }

    private /* synthetic */ void lambda$testHttpStatusExceptionFailurePropagation$5(Throwable rootCause, Throwable exception) {
        this.assertTrue(exception instanceof HttpStatusException);
        this.assertEquals(rootCause, exception);
    }

    private static /* synthetic */ Object lambda$testHttpStatusExceptionFailurePropagation$4(Throwable rootCause, InvocationOnMock invocation) throws Throwable {
        Handler resultHandler = (Handler)invocation.getArgument(1);
        resultHandler.handle((Object)Future.failedFuture((Throwable)rootCause));
        return null;
    }
}

