/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.ErrorHandler;
import org.junit.Test;

public class ErrorHandlerTest
extends WebTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.router.route().failureHandler((Handler)ErrorHandler.create());
    }

    @Test
    public void testFailWithStatusCodeSetContentTypeTextHtml() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            rc.fail(statusCode);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkHtmlResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeSetContentTypeApplicationJson() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            rc.fail(statusCode);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkJsonResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeSetContentTypeTextPlain() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            rc.fail(statusCode);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkTextResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeInferContentTypeTextHtml() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> rc.fail(statusCode));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("accept", "text/html"), resp -> resp.bodyHandler(buff -> {
            this.checkHtmlResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeInferContentTypeApplicationJson() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> rc.fail(statusCode));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("accept", "application/json"), resp -> resp.bodyHandler(buff -> {
            this.checkJsonResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeInferContentTypeTextPlain() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> rc.fail(statusCode));
        this.testRequest(HttpMethod.GET, "/", req -> req.putHeader("accept", "text/plain"), resp -> resp.bodyHandler(buff -> {
            this.checkTextResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithStatusCodeDefaultContentType() throws Exception {
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> rc.fail(statusCode));
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkTextResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithException() throws Exception {
        System.setProperty("vertxweb.environment", "dev");
        this.router.clear().route().failureHandler((Handler)ErrorHandler.create());
        System.setProperty("vertxweb.environment", "test");
        int statusCode = 500;
        String statusMessage = "Something happened!";
        Exception e = new Exception(statusMessage);
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            rc.fail((Throwable)e);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkHtmlResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, statusMessage, e);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    @Test
    public void testFailWithExceptionNoExceptionDetails() throws Exception {
        this.router.clear();
        this.router.route().failureHandler((Handler)ErrorHandler.create());
        int statusCode = 500;
        String statusMessage = "Something happened!";
        Exception e = new Exception(statusMessage);
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            rc.fail((Throwable)e);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            this.checkHtmlResponse((Buffer)buff, (HttpClientResponse)resp, statusCode, "Internal Server Error", e, false);
            this.testComplete();
        }), statusCode, "Internal Server Error", null);
        this.await();
    }

    @Test
    public void testSpecifyTemplate() throws Exception {
        this.router.clear();
        this.router.route().failureHandler((Handler)ErrorHandler.create((String)"test-error-template.html"));
        int statusCode = 404;
        String statusMessage = "Not Found";
        this.router.route().handler(rc -> {
            rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            rc.fail(statusCode);
        });
        this.testRequest(HttpMethod.GET, "/", null, resp -> resp.bodyHandler(buff -> {
            String page = buff.toString();
            this.assertEquals("<html><body>An unexpected error occurred.404.Not Found</body></html>", page);
            this.testComplete();
        }), statusCode, statusMessage, null);
        this.await();
    }

    private void checkHtmlResponse(Buffer buff, HttpClientResponse resp, int statusCode, String statusMessage) {
        this.checkHtmlResponse(buff, resp, statusCode, statusMessage, null);
    }

    private void checkHtmlResponse(Buffer buff, HttpClientResponse resp, int statusCode, String statusMessage, Exception e) {
        this.checkHtmlResponse(buff, resp, statusCode, statusMessage, e, true);
    }

    private void checkHtmlResponse(Buffer buff, HttpClientResponse resp, int statusCode, String statusMessage, Exception e, boolean displayExceptionDetails) {
        this.assertEquals("text/html", resp.headers().get(HttpHeaders.CONTENT_TYPE));
        String page = buff.toString();
        this.assertTrue(page.startsWith("<html>"));
        this.assertTrue(page.contains(String.valueOf(statusCode)));
        this.assertTrue(page.contains(statusMessage));
        this.assertTrue(page.contains("An unexpected error occurred"));
        if (e != null) {
            if (displayExceptionDetails) {
                this.assertTrue(page.contains(e.getStackTrace()[0].toString()));
            } else {
                this.assertFalse(page.contains(e.getStackTrace()[0].toString()));
            }
        }
    }

    private void checkJsonResponse(Buffer buff, HttpClientResponse resp, int statusCode, String statusMessage) {
        this.assertEquals("application/json", resp.headers().get(HttpHeaders.CONTENT_TYPE));
        String page = buff.toString();
        this.assertEquals("{\"error\":{\"code\":" + statusCode + ",\"message\":\"" + statusMessage + "\"}}", page);
    }

    private void checkTextResponse(Buffer buff, HttpClientResponse resp, int statusCode, String statusMessage) {
        this.assertEquals("text/plain", resp.headers().get(HttpHeaders.CONTENT_TYPE));
        String page = buff.toString();
        this.assertEquals("Error " + statusCode + ": " + statusMessage, page);
    }
}

