/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.JWTAuthHandler;
import org.junit.Before;
import org.junit.Test;

public class JWTAuthHandlerTest
extends WebTestBase {
    JWTAuth authProvider;

    @Before
    public void setup() throws Exception {
        JsonObject authConfig = new JsonObject().put("keyStore", new JsonObject().put("type", "jceks").put("path", "keystore.jceks").put("password", "secret"));
        this.authProvider = JWTAuth.create((Vertx)this.vertx, (JWTAuthOptions)new JWTAuthOptions(authConfig));
    }

    @Test
    public void testLogin() throws Exception {
        Handler handler = rc -> {
            this.assertNotNull(rc.user());
            this.assertEquals("paulo", rc.user().principal().getString("sub"));
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, resp -> {}, 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer " + this.authProvider.generateToken(new JsonObject().put("sub", "paulo"), (JWTOptions)new io.vertx.ext.jwt.JWTOptions())), 200, "OK", "Welcome to the protected resource!");
    }

    @Test
    public void testLoginFail() throws Exception {
        Handler handler = rc -> {
            this.fail("should not get here");
            rc.response().end("Welcome to the protected resource!");
        };
        this.router.route("/protected/*").handler((Handler)JWTAuthHandler.create((JWTAuth)this.authProvider));
        this.router.route("/protected/somepage").handler(handler);
        this.testRequest(HttpMethod.GET, "/protected/somepage", null, 401, "Unauthorized", null);
        String token = this.authProvider.generateToken(new JsonObject().put("sub", "paulo"), (JWTOptions)new io.vertx.ext.jwt.JWTOptions());
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Bearer x" + token), 401, "Unauthorized", null);
        this.testRequest(HttpMethod.GET, "/protected/somepage", req -> req.putHeader("Authorization", "Basic " + token), 401, "Unauthorized", null);
    }
}

