/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import io.vertx.test.core.TestUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import org.junit.Test;

public class SockJSSessionTest
extends SockJSTestBase {
    @Test
    public void testNoDeadlockWhenWritingFromAnotherThreadWithSseTransport() throws Exception {
        this.socketHandler = () -> socket -> {
            AtomicBoolean closed = new AtomicBoolean();
            socket.endHandler(v -> {
                closed.set(true);
                this.testComplete();
            });
            new Thread(() -> {
                while (!closed.get()) {
                    LockSupport.parkNanos(50L);
                    socket.write(Buffer.buffer((String)TestUtils.randomAlphaString((int)256)));
                }
            }).start();
        };
        this.startServers();
        this.client.get("/test/400/8ne8e94a/eventsource", resp -> {
            AtomicInteger count = new AtomicInteger();
            resp.handler(msg -> {
                if (count.incrementAndGet() == 400) {
                    resp.request().connection().close();
                }
            });
        }).end();
        this.await();
    }

    @Test
    public void testNoDeadlockWhenWritingFromAnotherThreadWithWebsocketTransport() throws Exception {
        int numMsg = 4000;
        this.waitFor(1);
        AtomicInteger clientReceived = new AtomicInteger();
        AtomicInteger serverReceived = new AtomicInteger();
        BooleanSupplier shallStop = () -> clientReceived.get() > numMsg * 256 && serverReceived.get() > numMsg * 256;
        this.socketHandler = () -> socket -> {
            socket.handler(msg -> serverReceived.addAndGet(msg.length()));
            socket.write("hello");
            new Thread(() -> {
                while (!shallStop.getAsBoolean()) {
                    LockSupport.parkNanos(50L);
                    try {
                        socket.write(Buffer.buffer((String)TestUtils.randomAlphaString((int)256)));
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }).start();
        };
        this.startServers();
        this.client.websocket("/test/400/8ne8e94a/websocket", ws -> ws.handler(msg -> {
            clientReceived.addAndGet(msg.length());
            ws.writeTextMessage("\"hello\"");
            if (shallStop.getAsBoolean()) {
                ws.handler(null);
                this.complete();
            }
        }));
        this.await();
    }

    @Test
    public void testCombineMultipleFramesIntoASingleMessage() throws Exception {
        this.socketHandler = () -> socket -> socket.handler(buf -> {
            this.assertEquals("Hello World", buf.toString());
            this.testComplete();
        });
        this.startServers();
        this.client.websocket("/test/400/8ne8e94a/websocket", ws -> {
            ws.writeFrame(WebSocketFrame.textFrame((String)"[\"Hello", (boolean)false));
            ws.writeFrame(WebSocketFrame.continuationFrame((Buffer)Buffer.buffer((String)" World\"]"), (boolean)true));
            ws.close();
        });
        this.await();
    }
}

