/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.handler.sockjs.SockJSTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Test;

public class SockJSStreamTest
extends SockJSTestBase {
    @Override
    public void setUp() throws Exception {
        this.numServers = 2;
        super.setUp();
    }

    @Test
    public void testStream() throws Exception {
        AtomicReference sessionContext = new AtomicReference();
        this.socketHandler = () -> socket -> {
            Context context = Vertx.currentContext();
            this.assertNotNull(context);
            this.assertTrue(sessionContext.compareAndSet(null, context));
            socket.setWriteQueueMaxSize(5);
            socket.write("Hello");
            this.assertTrue(socket.writeQueueFull());
            socket.drainHandler(v -> {
                this.assertEquals(sessionContext.get(), Vertx.currentContext());
                socket.write("World");
            });
        };
        this.startServers();
        List<String> messages = Collections.synchronizedList(new ArrayList());
        this.fetchMessages(messages);
        this.await();
    }

    private void fetchMessages(List<String> messages) {
        this.client.post("/test/400/8ne8e94a/xhr", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.bodyHandler(buffer -> {
                String body = buffer.toString();
                if (body.startsWith("a")) {
                    JsonArray content = new JsonArray(body.substring(1));
                    messages.addAll(content.stream().map(Object::toString).collect(Collectors.toList()));
                }
                if (messages.size() < 2) {
                    this.fetchMessages(messages);
                } else {
                    this.assertEquals(Arrays.asList("Hello", "World"), messages);
                    this.testComplete();
                }
            });
        }).end();
    }
}

