/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.BridgeEvent;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BridgeEventImpl;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventBusBridgeImpl
implements Handler<SockJSSocket> {
    private static final Logger log = LoggerFactory.getLogger(EventBusBridgeImpl.class);
    private final Map<SockJSSocket, SockInfo> sockInfos = new HashMap<SockJSSocket, SockInfo>();
    private final List<PermittedOptions> inboundPermitted;
    private final List<PermittedOptions> outboundPermitted;
    private final int maxAddressLength;
    private final int maxHandlersPerSocket;
    private final long pingTimeout;
    private final long replyTimeout;
    private final Vertx vertx;
    private final EventBus eb;
    private final Map<String, Message> messagesAwaitingReply = new HashMap<String, Message>();
    private final Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();
    private final Handler<BridgeEvent> bridgeEventHandler;

    public EventBusBridgeImpl(Vertx vertx, BridgeOptions options, Handler<BridgeEvent> bridgeEventHandler) {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.inboundPermitted = options.getInboundPermitteds() == null ? new ArrayList() : options.getInboundPermitteds();
        this.outboundPermitted = options.getOutboundPermitteds() == null ? new ArrayList() : options.getOutboundPermitteds();
        this.maxAddressLength = options.getMaxAddressLength();
        this.maxHandlersPerSocket = options.getMaxHandlersPerSocket();
        this.pingTimeout = options.getPingTimeout();
        this.replyTimeout = options.getReplyTimeout();
        this.bridgeEventHandler = bridgeEventHandler;
    }

    private void handleSocketClosed(SockJSSocket sock, Map<String, MessageConsumer> registrations) {
        PingInfo pingInfo;
        registrations.forEach((key, value) -> {
            value.unregister();
            this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.UNREGISTER, new JsonObject().put("type", (Object)"unregister").put("address", (Object)value.address()), sock), null, null);
        });
        SockInfo info = this.sockInfos.remove(sock);
        if (info != null && (pingInfo = info.pingInfo) != null) {
            this.vertx.cancelTimer(pingInfo.timerID);
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_CLOSED, null, sock), null, null);
    }

    private void handleSocketData(SockJSSocket sock, Buffer data, Map<String, MessageConsumer> registrations) {
        JsonObject msg;
        try {
            msg = new JsonObject(data.toString());
        }
        catch (DecodeException e) {
            EventBusBridgeImpl.replyError(sock, "invalid_json");
            return;
        }
        String type = msg.getString("type");
        if (type == null) {
            EventBusBridgeImpl.replyError(sock, "missing_type");
            return;
        }
        if (type.equals("ping")) {
            this.internalHandlePing(sock);
        } else {
            String address = msg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            switch (type) {
                case "send": {
                    this.internalHandleSendOrPub(sock, true, msg);
                    break;
                }
                case "publish": {
                    this.internalHandleSendOrPub(sock, false, msg);
                    break;
                }
                case "register": {
                    this.internalHandleRegister(sock, msg, registrations);
                    break;
                }
                case "unregister": {
                    this.internalHandleUnregister(sock, msg, registrations);
                    break;
                }
                default: {
                    log.error((Object)("Invalid type in incoming message: " + type));
                    EventBusBridgeImpl.replyError(sock, "invalid_type");
                }
            }
        }
    }

    private void checkCallHook(Supplier<BridgeEventImpl> eventSupplier, Runnable okAction, Runnable rejectAction) {
        if (this.bridgeEventHandler == null) {
            if (okAction != null) {
                okAction.run();
            }
        } else {
            BridgeEventImpl event = eventSupplier.get();
            this.bridgeEventHandler.handle((Object)event);
            event.future().setHandler(res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (okAction != null) {
                            okAction.run();
                        }
                    } else if (rejectAction != null) {
                        rejectAction.run();
                    } else {
                        log.debug((Object)"Bridge handler prevented send or pub");
                    }
                } else {
                    log.error((Object)"Failure in bridge event handler", res.cause());
                }
            });
        }
    }

    private void internalHandleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg) {
        this.checkCallHook(() -> new BridgeEventImpl(send ? BridgeEventType.SEND : BridgeEventType.PUBLISH, msg, sock), () -> {
            String address = msg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            this.doSendOrPub(send, sock, address, msg);
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private boolean checkMaxHandlers(SockJSSocket sock, SockInfo info) {
        if (info.handlerCount < this.maxHandlersPerSocket) {
            return true;
        }
        log.warn((Object)"Refusing to register as max_handlers_per_socket reached already");
        EventBusBridgeImpl.replyError(sock, "max_handlers_reached");
        return false;
    }

    private void internalHandleRegister(SockJSSocket sock, JsonObject rawMsg, Map<String, MessageConsumer> registrations) {
        SockInfo info = this.sockInfos.get(sock);
        if (!this.checkMaxHandlers(sock, info)) {
            return;
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.REGISTER, rawMsg, sock), () -> {
            boolean debug = log.isDebugEnabled();
            String address = rawMsg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            if (address.length() > this.maxAddressLength) {
                log.warn((Object)"Refusing to register as address length > max_address_length");
                EventBusBridgeImpl.replyError(sock, "max_address_length_reached");
                return;
            }
            Match match = this.checkMatches(false, address, null);
            if (match.doesMatch) {
                Handler handler = msg -> {
                    Match curMatch = this.checkMatches(false, address, msg.body());
                    if (curMatch.doesMatch) {
                        if (curMatch.requiredAuthority != null) {
                            this.authorise(curMatch, sock.webUser(), (Handler<AsyncResult<Boolean>>)((Handler)res -> {
                                if (res.succeeded()) {
                                    if (((Boolean)res.result()).booleanValue()) {
                                        this.checkAddAccceptedReplyAddress((Message)msg);
                                        this.deliverMessage(sock, address, (Message)msg);
                                    } else if (debug) {
                                        log.debug((Object)("Outbound message for address " + address + " rejected because auth is required and socket is not authed"));
                                    }
                                } else {
                                    log.error((Object)res.cause());
                                }
                            }));
                        } else {
                            this.checkAddAccceptedReplyAddress((Message)msg);
                            this.deliverMessage(sock, address, (Message)msg);
                        }
                    } else if (debug) {
                        log.debug((Object)("Outbound message for address " + address + " rejected because there is no inbound match"));
                    }
                };
                MessageConsumer reg = this.eb.consumer(address).handler(handler);
                registrations.put(address, reg);
                ++info.handlerCount;
                this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.REGISTERED, rawMsg, sock), null, null);
            } else {
                if (debug) {
                    log.debug((Object)("Cannot register handler for address " + address + " because there is no inbound match"));
                }
                EventBusBridgeImpl.replyError(sock, "access_denied");
            }
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private void internalHandleUnregister(SockJSSocket sock, JsonObject rawMsg, Map<String, MessageConsumer> registrations) {
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.UNREGISTER, rawMsg, sock), () -> {
            String address = rawMsg.getString("address");
            if (address == null) {
                EventBusBridgeImpl.replyError(sock, "missing_address");
                return;
            }
            Match match = this.checkMatches(false, address, null);
            if (match.doesMatch) {
                MessageConsumer reg = (MessageConsumer)registrations.remove(address);
                if (reg != null) {
                    reg.unregister();
                    SockInfo info = this.sockInfos.get(sock);
                    --info.handlerCount;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot unregister handler for address " + address + " because there is no inbound match"));
                }
                EventBusBridgeImpl.replyError(sock, "access_denied");
            }
        }, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
    }

    private void internalHandlePing(SockJSSocket sock) {
        SockInfo info;
        Session webSession = sock.webSession();
        if (webSession != null) {
            webSession.setAccessed();
        }
        if ((info = this.sockInfos.get(sock)) != null) {
            info.pingInfo.lastPing = System.currentTimeMillis();
            this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_PING, null, sock), null, null);
        }
    }

    public void handle(SockJSSocket sock) {
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_CREATED, null, sock), () -> {
            HashMap registrations = new HashMap();
            sock.endHandler(v -> this.handleSocketClosed(sock, registrations));
            sock.handler(data -> this.handleSocketData(sock, (Buffer)data, registrations));
            PingInfo pingInfo = new PingInfo();
            pingInfo.timerID = this.vertx.setPeriodic(this.pingTimeout, id -> {
                if (System.currentTimeMillis() - pingInfo.lastPing >= this.pingTimeout) {
                    this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.SOCKET_IDLE, null, sock), ((SockJSSocketBase)sock)::closeAfterSessionExpired, () -> EventBusBridgeImpl.replyError(sock, "rejected"));
                }
            });
            SockInfo sockInfo = new SockInfo();
            sockInfo.pingInfo = pingInfo;
            this.sockInfos.put(sock, sockInfo);
        }, sock::close);
    }

    private void checkAddAccceptedReplyAddress(Message message) {
        String replyAddress = message.replyAddress();
        if (replyAddress != null) {
            this.messagesAwaitingReply.put(replyAddress, message);
            this.vertx.setTimer(this.replyTimeout, tid -> this.messagesAwaitingReply.remove(replyAddress));
        }
    }

    private void deliverMessage(SockJSSocket sock, String address, Message message) {
        JsonObject envelope = new JsonObject().put("type", (Object)"rec").put("address", (Object)address).put("body", message.body());
        if (message.replyAddress() != null) {
            envelope.put("replyAddress", (Object)message.replyAddress());
        }
        if (message.headers() != null && !message.headers().isEmpty()) {
            JsonObject headersCopy = new JsonObject();
            for (String name : message.headers().names()) {
                List values = message.headers().getAll(name);
                if (values.size() == 1) {
                    headersCopy.put(name, values.get(0));
                    continue;
                }
                headersCopy.put(name, (Object)values);
            }
            envelope.put("headers", (Object)headersCopy);
        }
        this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.RECEIVE, envelope, sock), () -> sock.write(Buffer.buffer((String)envelope.encode())), () -> log.debug((Object)"outbound message rejected by bridge event handler"));
    }

    private void doSendOrPub(boolean send, SockJSSocket sock, String address, JsonObject message) {
        Message awaitingReply;
        Object body = message.getValue("body");
        JsonObject headers = message.getJsonObject("headers");
        String replyAddress = message.getString("replyAddress");
        if (replyAddress != null && replyAddress.length() > 36) {
            log.error((Object)"Will not send message, reply address is > 36 chars");
            EventBusBridgeImpl.replyError(sock, "invalid_reply_address");
            return;
        }
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Received msg from client in bridge. address:" + address + " message:" + body));
        }
        Match curMatch = (awaitingReply = this.messagesAwaitingReply.remove(address)) != null ? new Match(true) : this.checkMatches(true, address, body);
        if (curMatch.doesMatch) {
            if (curMatch.requiredAuthority != null) {
                User webUser = sock.webUser();
                if (webUser != null) {
                    this.authorise(curMatch, webUser, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
                        if (res.succeeded()) {
                            if (((Boolean)res.result()).booleanValue()) {
                                this.checkAndSend(send, address, body, headers, sock, replyAddress, null);
                            } else {
                                EventBusBridgeImpl.replyError(sock, "access_denied");
                                if (debug) {
                                    log.debug((Object)("Inbound message for address " + address + " rejected because is not authorised"));
                                }
                            }
                        } else {
                            EventBusBridgeImpl.replyError(sock, "auth_error");
                            log.error((Object)"Error in performing authorisation", res.cause());
                        }
                    }));
                } else {
                    EventBusBridgeImpl.replyError(sock, "not_logged_in");
                    if (debug) {
                        log.debug((Object)("Inbound message for address " + address + " rejected because it requires auth and user is not authenticated"));
                    }
                }
            } else {
                this.checkAndSend(send, address, body, headers, sock, replyAddress, awaitingReply);
            }
        } else {
            EventBusBridgeImpl.replyError(sock, "access_denied");
            if (debug) {
                log.debug((Object)("Inbound message for address " + address + " rejected because there is no match"));
            }
        }
    }

    private void checkAndSend(boolean send, String address, Object body, JsonObject headers, SockJSSocket sock, String replyAddress, Message awaitingReply) {
        CaseInsensitiveHeaders mHeaders;
        SockInfo info = this.sockInfos.get(sock);
        if (replyAddress != null && !this.checkMaxHandlers(sock, info)) {
            return;
        }
        Handler replyHandler = replyAddress != null ? result -> {
            if (result.succeeded()) {
                Message message = (Message)result.result();
                this.checkAddAccceptedReplyAddress(message);
                this.deliverMessage(sock, replyAddress, message);
            } else {
                ReplyException cause = (ReplyException)result.cause();
                JsonObject envelope = new JsonObject().put("type", (Object)"err").put("address", (Object)replyAddress).put("failureCode", (Object)cause.failureCode()).put("failureType", (Object)cause.failureType().name()).put("message", (Object)cause.getMessage());
                sock.write(Buffer.buffer((String)envelope.encode()));
            }
            --info.handlerCount;
        } : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Forwarding message to address " + address + " on event bus"));
        }
        if (headers != null) {
            mHeaders = new CaseInsensitiveHeaders();
            headers.forEach(arg_0 -> EventBusBridgeImpl.lambda$checkAndSend$30((MultiMap)mHeaders, arg_0));
        } else {
            mHeaders = null;
        }
        if (send) {
            if (awaitingReply != null) {
                if (replyAddress != null) {
                    awaitingReply.replyAndRequest(body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders((MultiMap)mHeaders), replyHandler);
                } else {
                    awaitingReply.reply(body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders((MultiMap)mHeaders));
                }
            } else if (replyAddress != null) {
                this.eb.request(address, body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders((MultiMap)mHeaders), replyHandler);
            } else {
                this.eb.send(address, body, new DeliveryOptions().setSendTimeout(this.replyTimeout).setHeaders((MultiMap)mHeaders));
            }
            if (replyAddress != null) {
                ++info.handlerCount;
            }
        } else {
            this.eb.publish(address, body, new DeliveryOptions().setHeaders((MultiMap)mHeaders));
        }
    }

    private void authorise(Match curMatch, User webUser, Handler<AsyncResult<Boolean>> handler) {
        if (curMatch.requiredAuthority != null) {
            webUser.isAuthorized(curMatch.requiredAuthority, res -> {
                if (res.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)res.result()));
                } else {
                    log.error((Object)res.cause());
                }
            });
        }
    }

    private Match checkMatches(boolean inbound, String address, Object body) {
        List<PermittedOptions> matches = inbound ? this.inboundPermitted : this.outboundPermitted;
        for (PermittedOptions matchHolder : matches) {
            boolean matched;
            String matchAddress = matchHolder.getAddress();
            String matchRegex = matchAddress == null ? matchHolder.getAddressRegex() : null;
            boolean addressOK = matchAddress == null ? matchRegex == null || this.regexMatches(matchRegex, address) : matchAddress.equals(address);
            if (!addressOK || !(matched = EventBusBridgeImpl.structureMatches(matchHolder.getMatch(), body))) continue;
            String requiredAuthority = matchHolder.getRequiredAuthority();
            return new Match(true, requiredAuthority);
        }
        return new Match(false);
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.computeIfAbsent(matchRegex, Pattern::compile);
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private static void replyError(SockJSSocket sock, String err) {
        JsonObject envelope = new JsonObject().put("type", (Object)"err").put("body", (Object)err);
        sock.write(Buffer.buffer((String)envelope.encode()));
    }

    private static boolean structureMatches(JsonObject match, Object bodyObject) {
        if (match == null || bodyObject == null) {
            return true;
        }
        if (bodyObject instanceof JsonObject) {
            JsonObject body = (JsonObject)bodyObject;
            for (String fieldName : match.fieldNames()) {
                Object mv = match.getValue(fieldName);
                Object bv = body.getValue(fieldName);
                if (!(mv instanceof JsonObject ? !EventBusBridgeImpl.structureMatches((JsonObject)mv, bv) : !match.getValue(fieldName).equals(body.getValue(fieldName)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$checkAndSend$30(MultiMap mHeaders, Map.Entry entry) {
        mHeaders.add((String)entry.getKey(), entry.getValue().toString());
    }

    private static final class SockInfo {
        int handlerCount;
        PingInfo pingInfo;

        private SockInfo() {
        }
    }

    private static final class PingInfo {
        long lastPing;
        long timerID;

        private PingInfo() {
        }
    }

    private static class Match {
        public final boolean doesMatch;
        public final String requiredAuthority;

        Match(boolean doesMatch, String requiredAuthority) {
            this.doesMatch = doesMatch;
            this.requiredAuthority = requiredAuthority;
        }

        Match(boolean doesMatch) {
            this.doesMatch = doesMatch;
            this.requiredAuthority = null;
        }
    }
}

