/*
 * Copyright 2014 Red Hat, Inc.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  and Apache License v2.0 which accompanies this distribution.
 *
 *  The Eclipse Public License is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  The Apache License v2.0 is available at
 *  http://www.opensource.org/licenses/apache2.0.php
 *
 *  You may elect to redistribute this code under either of these licenses.
 */

package io.vertx.ext.web.handler;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.VirtualHostHandlerImpl;

/**
 * Handler that will filter requests based on the request Host name.
 *
 * @author <a href="mailto:plopes@redhat.com">Paulo Lopes</a>
 * @deprecated Use {@link Route#virtualHost(String)}
 */
@VertxGen
@Deprecated
public interface VirtualHostHandler extends Handler<RoutingContext> {

  /**
   * Create a handler
   *
   * @return the handler
   */
  static VirtualHostHandler create(String hostname, Handler<RoutingContext> handler) {
    return new VirtualHostHandlerImpl(hostname, handler);
  }
}
