/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;

public abstract class AuthenticationHandlerImpl
implements AuthenticationHandler {
    static final String AUTH_PROVIDER_CONTEXT_KEY = "io.vertx.ext.web.handler.AuthenticationHandler.provider";
    static final HttpStatusException UNAUTHORIZED = new HttpStatusException(401);
    static final HttpStatusException BAD_REQUEST = new HttpStatusException(400);
    protected final String realm;
    protected final AuthenticationProvider authProvider;

    public AuthenticationHandlerImpl(AuthenticationProvider authProvider) {
        this(authProvider, "");
    }

    public AuthenticationHandlerImpl(AuthenticationProvider authProvider, String realm) {
        this.authProvider = authProvider;
        this.realm = realm;
    }

    public void handle(RoutingContext ctx) {
        if (this.handlePreflight(ctx)) {
            return;
        }
        User user = ctx.user();
        if (user != null) {
            ctx.next();
            return;
        }
        this.parseCredentials(ctx, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.failed()) {
                this.processException(ctx, res.cause());
                return;
            }
            User updatedUser = ctx.user();
            if (updatedUser != null) {
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                }
                ctx.next();
                return;
            }
            this.getAuthProvider(ctx).authenticate((JsonObject)res.result(), authN -> {
                if (authN.succeeded()) {
                    User authenticated = (User)authN.result();
                    ctx.setUser(authenticated);
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                    }
                    ctx.next();
                } else {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    if (authN.cause() instanceof HttpStatusException) {
                        this.processException(ctx, authN.cause());
                    } else {
                        this.processException(ctx, new HttpStatusException(401, authN.cause()));
                    }
                }
            });
        }));
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (exception != null && exception instanceof HttpStatusException) {
            int statusCode = ((HttpStatusException)exception).getStatusCode();
            String payload = ((HttpStatusException)exception).getPayload();
            switch (statusCode) {
                case 302: {
                    ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(302).end("Redirecting to " + payload + ".");
                    return;
                }
                case 401: {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    ctx.fail(401, exception);
                    return;
                }
            }
            ctx.fail(statusCode, exception);
            return;
        }
        ctx.fail(exception);
    }

    private boolean handlePreflight(RoutingContext ctx) {
        String accessControlRequestHeader;
        HttpServerRequest request = ctx.request();
        if (request.method() == HttpMethod.OPTIONS && (accessControlRequestHeader = ctx.request().getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            for (String ctrlReq : accessControlRequestHeader.split(",")) {
                if (!ctrlReq.equalsIgnoreCase("Authorization")) continue;
                ctx.next();
                return true;
            }
        }
        return false;
    }

    protected AuthenticationProvider getAuthProvider(RoutingContext ctx) {
        try {
            AuthenticationProvider provider = (AuthenticationProvider)ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
            if (provider != null) {
                return provider;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.authProvider;
    }
}

