/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.MethodOverrideHandler;

public class MethodOverrideHandlerImpl
implements MethodOverrideHandler {
    private boolean useSafeDowngrade;

    public MethodOverrideHandlerImpl() {
        this(true);
    }

    public MethodOverrideHandlerImpl(boolean useSafeDowngrade) {
        this.useSafeDowngrade = useSafeDowngrade;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpMethod from = request.method();
        HttpMethod to = this.methodFromHeader(request);
        if (to != null && from != to && this.canOverride(from, to)) {
            context.reroute(to, request.path());
        } else {
            context.next();
        }
    }

    private HttpMethod methodFromHeader(HttpServerRequest request) {
        String method = request.headers().get("X-HTTP-METHOD-OVERRIDE");
        return method != null ? HttpMethod.valueOf((String)method) : null;
    }

    private boolean canOverride(HttpMethod from, HttpMethod to) {
        if (!this.useSafeDowngrade) {
            return true;
        }
        return HttpMethodTraits.isIdempotent(to) || HttpMethodTraits.isSafe(to) && !HttpMethodTraits.isIdempotent(from) || !HttpMethodTraits.isSafe(from);
    }

    private static interface HttpMethodTraits {
        public static boolean isIdempotent(HttpMethod method) {
            switch (method.name()) {
                case "GET": 
                case "HEAD": 
                case "PUT": 
                case "PATCH": 
                case "DELETE": {
                    return true;
                }
            }
            return false;
        }

        public static boolean isSafe(HttpMethod method) {
            switch (method.name()) {
                case "GET": 
                case "HEAD": {
                    return true;
                }
            }
            return false;
        }
    }
}

