/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import io.vertx.ext.web.impl.Origin;
import java.util.ArrayList;
import java.util.List;

public class OAuth2AuthHandlerImpl
extends HTTPAuthorizationHandler<OAuth2Auth>
implements OAuth2AuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthHandlerImpl.class);
    private final VertxContextPRNG prng;
    private final String host;
    private final String callbackPath;
    private Route callback;
    private JsonObject extraParams;
    private final List<String> scopes = new ArrayList<String>();
    private String prompt;
    private boolean bearerOnly = true;

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER);
        this.prng = VertxContextPRNG.current((Vertx)vertx);
        if (callbackURL != null) {
            Origin origin = Origin.parse(callbackURL);
            this.host = origin.toString();
            this.callbackPath = origin.resource();
        } else {
            this.host = null;
            this.callbackPath = null;
        }
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        this.parseAuthorization(context, !this.bearerOnly, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            if (token == null) {
                if (this.callback == null) {
                    handler.handle((Object)Future.failedFuture((String)"callback route is not configured."));
                    return;
                }
                if (context.request().method() == HttpMethod.GET && context.normalizedPath().equals(this.callback.getPath())) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"The callback route is shaded by the OAuth2AuthHandler, ensure the callback route is added BEFORE the OAuth2AuthHandler route!");
                    }
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(500, "Infinite redirect loop [oauth2 callback]")));
                } else {
                    String redirectUri = context.request().uri();
                    String state = null;
                    if (context.session() != null) {
                        context.session().put("redirect_uri", context.request().uri());
                        state = this.prng.nextString(6);
                        context.session().put("state", state);
                    }
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(302, this.authURI(redirectUri, state))));
                }
            } else {
                ((OAuth2Auth)this.authProvider).authenticate((Credentials)new TokenCredentials(token), decodeToken -> {
                    if (decodeToken.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)new HttpStatusException(401, decodeToken.cause().getMessage())));
                        return;
                    }
                    context.setUser((User)decodeToken.result());
                    handler.handle((Object)Future.succeededFuture());
                });
            }
        }));
    }

    private String authURI(String redirectURL, String state) {
        JsonObject config = new JsonObject().put("state", (Object)(state != null ? state : redirectURL));
        if (this.host != null) {
            config.put("redirect_uri", (Object)(this.host + this.callback.getPath()));
        }
        if (this.scopes.size() > 0) {
            config.put("scopes", this.scopes);
        }
        if (this.prompt != null) {
            config.put("prompt", (Object)this.prompt);
        }
        if (this.extraParams != null) {
            config.mergeIn(this.extraParams);
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(config);
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler withScope(String scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public OAuth2AuthHandler prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        if (this.callbackPath != null && !"".equals(this.callbackPath) && !this.callbackPath.equals(route.getPath())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"route path changed to match callback URL");
            }
            route.path(this.callbackPath);
        }
        route.method(HttpMethod.GET);
        route.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String resource;
            String error = ctx.request().getParam("error");
            if (error != null) {
                String errorDescription = ctx.request().getParam("error_description");
                if (errorDescription != null) {
                    ctx.response().setStatusMessage(error + ": " + errorDescription);
                } else {
                    ctx.response().setStatusMessage(error);
                }
                ctx.fail(400);
                return;
            }
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.response().setStatusMessage("Missing code parameter");
                ctx.fail(400);
                return;
            }
            String state = ctx.request().getParam("state");
            if (ctx.session() != null) {
                String ctxState = (String)ctx.session().remove("state");
                if (ctxState != null && !ctxState.equals(state)) {
                    ctx.fail(401);
                    return;
                }
                resource = (String)ctx.session().get("redirect_uri");
            } else {
                resource = state;
            }
            Oauth2Credentials credentials = new Oauth2Credentials().setCode(code);
            if (this.host == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Cannot compute: 'redirect_uri' variable. OAuth2AuthHandler was created without a origin/callback URL.");
                }
            } else {
                credentials.setRedirectUri(this.host + route.getPath());
            }
            if (this.extraParams != null) {
                credentials.setExtra(this.extraParams);
            }
            ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials, res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    ctx.setUser((User)res.result());
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                        ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)(resource != null ? resource : "/")).setStatusCode(302).end("Redirecting to " + (resource != null ? resource : "/") + ".");
                    } else {
                        ctx.reroute(resource != null ? resource : "/");
                    }
                }
            });
        }));
        this.bearerOnly = false;
        this.callback = route;
        return this;
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        if (this.realm != null && this.realm.length() > 0) {
            return "Bearer realm=\"" + this.realm + "\"";
        }
        return null;
    }
}

