/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.util.ArrayList;
import java.util.List;

public class ChainAuthHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements ChainAuthHandler {
    private final List<AuthenticationHandler> handlers = new ArrayList<AuthenticationHandler>();
    private final boolean all;
    private boolean willRedirect = false;

    public ChainAuthHandlerImpl(boolean all) {
        super(null);
        this.all = all;
    }

    @Override
    public synchronized ChainAuthHandler add(AuthenticationHandler other) {
        if (this.willRedirect) {
            throw new IllegalStateException("Cannot add a handler after a handler known to perform a HTTP redirect [RedirectAuthHandler/Oauth2Handler]");
        }
        this.handlers.add(other);
        if (other instanceof RedirectAuthHandler || other instanceof OAuth2AuthHandler) {
            this.willRedirect = true;
        }
        if (other instanceof ChainAuthHandler) {
            this.willRedirect &= ((ChainAuthHandlerImpl)other).willRedirect;
        }
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        if (this.handlers.size() == 0) {
            handler.handle((Object)Future.failedFuture((String)"No providers in the auth chain."));
        } else {
            this.iterate(0, context, null, null, handler);
        }
    }

    private void iterate(int idx, RoutingContext ctx, Credentials result, HttpStatusException exception, Handler<AsyncResult<Credentials>> handler) {
        if (idx >= this.handlers.size()) {
            if (this.all) {
                if (exception == null) {
                    handler.handle((Object)Future.succeededFuture((Object)result));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)exception));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return;
        }
        AuthenticationHandler authHandler = this.handlers.get(idx);
        authHandler.parseCredentials(ctx, (Handler<AsyncResult<Credentials>>)((Handler)res -> {
            if (res.failed()) {
                if (!this.all && res.cause() instanceof HttpStatusException) {
                    HttpStatusException ex = (HttpStatusException)res.cause();
                    switch (ex.getStatusCode()) {
                        case 302: 
                        case 400: 
                        case 401: 
                        case 403: {
                            this.iterate(idx + 1, ctx, null, ex, handler);
                            return;
                        }
                    }
                }
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            if (authHandler instanceof AuthenticationHandlerImpl) {
                ctx.put("io.vertx.ext.web.handler.AuthenticationHandler.provider", ((AuthenticationHandlerImpl)authHandler).getAuthProvider(ctx));
            }
            if (this.all) {
                this.iterate(idx + 1, ctx, (Credentials)res.result(), null, handler);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)res.result()));
            }
        }));
    }

    @Override
    public String authenticateHeader(RoutingContext ctx) {
        for (AuthenticationHandler authHandler : this.handlers) {
            String header = authHandler.authenticateHeader(ctx);
            if (header == null) continue;
            return header;
        }
        return null;
    }
}

